/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.immutables.builder.Builder;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.ComputerBuilder;
import org.neo4j.gds.beta.pregel.ForkJoinComputer;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PartitionedComputer;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.StringFormatting;

abstract class PregelComputer<CONFIG extends PregelConfig> {
    final Graph graph;
    final PregelComputation<CONFIG> computation;
    final CONFIG config;
    final NodeValue nodeValues;
    final Messenger<?> messenger;
    final HugeAtomicBitSet voteBits;
    final ProgressTracker progressTracker;

    PregelComputer(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, NodeValue nodeValues, Messenger<?> messenger, HugeAtomicBitSet voteBits, ProgressTracker progressTracker) {
        this.graph = graph;
        this.computation = computation;
        this.config = config;
        this.nodeValues = nodeValues;
        this.messenger = messenger;
        this.voteBits = voteBits;
        this.progressTracker = progressTracker;
    }

    abstract void initComputation();

    abstract void initIteration(int var1);

    abstract void runIteration();

    abstract boolean hasConverged();

    abstract void release();

    static <CONFIG extends PregelConfig> ComputerBuilder<CONFIG> builder() {
        return new ComputerBuilder();
    }

    @Builder.Factory
    static <CONFIG extends PregelConfig> PregelComputer<CONFIG> computer(Graph graph, PregelComputation<CONFIG> computation, CONFIG config, NodeValue nodeValues, Messenger<?> messenger, HugeAtomicBitSet voteBits, ExecutorService executorService, ProgressTracker progressTracker) {
        if (config.useForkJoin()) {
            if (!(executorService instanceof ForkJoinPool)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Required ForkJoinPool, got %s", (Object[])new Object[]{executorService.getClass()}));
            }
            return new ForkJoinComputer<CONFIG>(graph, computation, config, nodeValues, messenger, voteBits, (ForkJoinPool)executorService, progressTracker);
        }
        return new PartitionedComputer<CONFIG>(graph, computation, config, nodeValues, messenger, voteBits, config.concurrency(), executorService, progressTracker);
    }
}

