/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public enum Partitioning {
    RANGE,
    DEGREE,
    AUTO;

    private static final List<String> VALUES;

    @Nullable
    public static Partitioning parse(Object input) {
        if (input instanceof String) {
            String inputString = ((String)input).toUpperCase(Locale.ENGLISH);
            if (!VALUES.contains(inputString)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Partitioning with name `%s` does not exist. Available options are %s.", (Object[])new Object[]{inputString, StringJoining.join(VALUES)}));
            }
            return Partitioning.valueOf(inputString);
        }
        return (Partitioning)((Object)input);
    }

    public static String toString(Partitioning partitioning) {
        return partitioning.toString();
    }

    static {
        VALUES = Arrays.stream(Partitioning.values()).map(Enum::name).collect(Collectors.toList());
    }
}

