/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.pregel.Element;
import org.neo4j.gds.beta.pregel.PregelSchema;

@Generated(from="PregelSchema", generator="Immutables")
public final class ImmutablePregelSchema
implements PregelSchema {
    private final Set<Element> elements;

    private ImmutablePregelSchema(Iterable<? extends Element> elements) {
        this.elements = ImmutablePregelSchema.createUnmodifiableSet(ImmutablePregelSchema.createSafeList(elements, true, false));
    }

    private ImmutablePregelSchema(ImmutablePregelSchema original, Set<Element> elements) {
        this.elements = elements;
    }

    @Override
    public Set<Element> elements() {
        return this.elements;
    }

    public final ImmutablePregelSchema withElements(Element ... elements) {
        Set<Element> newValue = ImmutablePregelSchema.createUnmodifiableSet(ImmutablePregelSchema.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePregelSchema(this, newValue);
    }

    public final ImmutablePregelSchema withElements(Iterable<? extends Element> elements) {
        if (this.elements == elements) {
            return this;
        }
        Set<Element> newValue = ImmutablePregelSchema.createUnmodifiableSet(ImmutablePregelSchema.createSafeList(elements, true, false));
        return new ImmutablePregelSchema(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePregelSchema && this.equalTo((ImmutablePregelSchema)another);
    }

    private boolean equalTo(ImmutablePregelSchema another) {
        return this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.elements.hashCode();
        return h;
    }

    public String toString() {
        return "PregelSchema{elements=" + this.elements + "}";
    }

    public static PregelSchema of(Set<Element> elements) {
        return ImmutablePregelSchema.of(elements);
    }

    public static PregelSchema of(Iterable<? extends Element> elements) {
        return new ImmutablePregelSchema(elements);
    }

    public static PregelSchema copyOf(PregelSchema instance) {
        if (instance instanceof ImmutablePregelSchema) {
            return (ImmutablePregelSchema)instance;
        }
        return ImmutablePregelSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="PregelSchema", generator="Immutables")
    public static final class Builder
    extends PregelSchema.Builder {
        private List<Element> elements = null;

        private Builder() {
        }

        public final Builder from(PregelSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElements(instance.elements());
            return this;
        }

        public final Builder addElement(Element element) {
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
            }
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        public final Builder addElements(Element ... elements) {
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
            }
            for (Element element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public final Builder elements(Iterable<? extends Element> elements) {
            this.elements = new ArrayList<Element>();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<? extends Element> elements) {
            Objects.requireNonNull(elements, "elements element");
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
            }
            for (Element element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public Builder clear() {
            if (this.elements != null) {
                this.elements.clear();
            }
            return this;
        }

        @Override
        public PregelSchema build() {
            return new ImmutablePregelSchema(null, this.elements == null ? Collections.emptySet() : ImmutablePregelSchema.createUnmodifiableSet(this.elements));
        }
    }
}

