/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel.context;

import org.neo4j.gds.beta.pregel.ComputeStep;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.context.NodeCentricContext;

public final class ComputeContext<CONFIG extends PregelConfig>
extends NodeCentricContext<CONFIG> {
    private final SendMessagesFunction sendMessagesFunction;

    public ComputeContext(ComputeStep<CONFIG, ?> computeStep, CONFIG config) {
        super(computeStep, config);
        this.sendMessagesFunction = config.hasRelationshipWeightProperty() ? computeStep::sendToNeighborsWeighted : computeStep::sendToNeighbors;
    }

    public double doubleNodeValue(String key) {
        return this.computeStep.doubleNodeValue(key, this.nodeId);
    }

    public long longNodeValue(String key) {
        return this.computeStep.longNodeValue(key, this.nodeId);
    }

    public long[] longArrayNodeValue(String key) {
        return this.computeStep.longArrayNodeValue(key, this.nodeId);
    }

    public long[] longArrayNodeValue(String key, long id) {
        return this.computeStep.longArrayNodeValue(key, id);
    }

    public double[] doubleArrayNodeValue(String key) {
        return this.computeStep.doubleArrayNodeValue(key, this.nodeId);
    }

    public void voteToHalt() {
        this.computeStep.voteToHalt(this.nodeId);
    }

    public boolean isInitialSuperstep() {
        return this.superstep() == 0;
    }

    public int superstep() {
        return this.computeStep.iteration();
    }

    public void sendToNeighbors(double message) {
        this.sendMessagesFunction.sendToNeighbors(this.nodeId, message);
    }

    public void sendTo(long targetNodeId, double message) {
        this.computeStep.sendTo(targetNodeId, message);
    }

    @FunctionalInterface
    static interface SendMessagesFunction {
        public void sendToNeighbors(long var1, double var3);
    }
}

