/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

public interface Reducer {
    public double identity();

    public double reduce(double var1, double var3);

    public static class Count
    implements Reducer {
        @Override
        public double identity() {
            return 0.0;
        }

        @Override
        public double reduce(double current, double message) {
            return current + 1.0;
        }
    }

    public static class Max
    implements Reducer {
        @Override
        public double identity() {
            return -1.7976931348623157E308;
        }

        @Override
        public double reduce(double current, double message) {
            return Math.max(current, message);
        }
    }

    public static class Min
    implements Reducer {
        @Override
        public double identity() {
            return Double.MAX_VALUE;
        }

        @Override
        public double reduce(double current, double message) {
            return Math.min(current, message);
        }
    }

    public static class Sum
    implements Reducer {
        @Override
        public double identity() {
            return 0.0;
        }

        @Override
        public double reduce(double current, double message) {
            return current + message;
        }
    }
}

