/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.Arrays;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.PrimitiveDoubleQueues;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.mem.MemoryUsage;

public final class PrimitiveSyncDoubleQueues
extends PrimitiveDoubleQueues {
    private HugeObjectArray<double[]> prevQueues;
    private HugeAtomicLongArray prevTails;

    public static PrimitiveSyncDoubleQueues of(long nodeCount, AllocationTracker allocationTracker) {
        return PrimitiveSyncDoubleQueues.of(nodeCount, 42, allocationTracker);
    }

    public static PrimitiveSyncDoubleQueues of(long nodeCount, int initialQueueCapacity, AllocationTracker allocationTracker) {
        HugeAtomicLongArray currentTails = HugeAtomicLongArray.newArray((long)nodeCount, (AllocationTracker)allocationTracker);
        HugeAtomicLongArray prevTails = HugeAtomicLongArray.newArray((long)nodeCount, (AllocationTracker)allocationTracker);
        HugeObjectArray currentQueues = HugeObjectArray.newArray(double[].class, (long)nodeCount, (AllocationTracker)allocationTracker);
        HugeObjectArray prevQueues = HugeObjectArray.newArray(double[].class, (long)nodeCount, (AllocationTracker)allocationTracker);
        HugeAtomicLongArray referenceCounts = HugeAtomicLongArray.newArray((long)nodeCount, (AllocationTracker)allocationTracker);
        int capacity = Math.max(initialQueueCapacity, 42);
        currentQueues.setAll(value -> new double[capacity]);
        prevQueues.setAll(value -> new double[capacity]);
        return new PrimitiveSyncDoubleQueues((HugeObjectArray<double[]>)currentQueues, currentTails, (HugeObjectArray<double[]>)prevQueues, prevTails, referenceCounts);
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(PrimitiveSyncDoubleQueues.class).add("current queues", HugeObjectArray.memoryEstimation((long)MemoryUsage.sizeOfDoubleArray((long)42L))).add("previous queues", HugeObjectArray.memoryEstimation((long)MemoryUsage.sizeOfDoubleArray((long)42L))).perNode("current tails", HugeAtomicLongArray::memoryEstimation).perNode("previous tails", HugeAtomicLongArray::memoryEstimation).perNode("reference counts", HugeAtomicLongArray::memoryEstimation).build();
    }

    private PrimitiveSyncDoubleQueues(HugeObjectArray<double[]> currentQueues, HugeAtomicLongArray currentTails, HugeObjectArray<double[]> prevQueues, HugeAtomicLongArray prevTails, HugeAtomicLongArray referenceCounts) {
        super(currentQueues, currentTails, referenceCounts);
        this.prevQueues = prevQueues;
        this.prevTails = prevTails;
    }

    void swapQueues() {
        HugeAtomicLongArray tmpTails = this.tails;
        this.tails = this.prevTails;
        this.prevTails = tmpTails;
        this.tails.setAll(0L);
        HugeObjectArray tmpQueues = this.queues;
        this.queues = this.prevQueues;
        this.prevQueues = tmpQueues;
    }

    void initIterator(Iterator iterator, long nodeId) {
        iterator.init((double[])this.prevQueues.get(nodeId), (int)this.prevTails.get(nodeId));
    }

    @Override
    void grow(long nodeId, int minCapacity) {
        double[] queue = (double[])this.queues.get(nodeId);
        int capacity = queue.length;
        int newCapacity = capacity + (capacity >> 1);
        this.queues.set(nodeId, (Object)Arrays.copyOf(queue, newCapacity));
    }

    @Override
    void release() {
        super.release();
        this.prevTails.release();
        this.prevQueues.release();
    }

    static class Iterator
    implements Messages.MessageIterator {
        double[] queue;
        private int length;
        private int pos;

        Iterator() {
        }

        void init(double[] queue, int length) {
            this.queue = queue;
            this.pos = 0;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.length;
        }

        @Override
        public double nextDouble() {
            return this.queue[this.pos++];
        }

        @Override
        public boolean isEmpty() {
            return this.length == 0;
        }
    }
}

