/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Value;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.AsyncQueueMessenger;
import org.neo4j.gds.beta.pregel.ImmutablePregelConfig;
import org.neo4j.gds.beta.pregel.ImmutablePregelResult;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PartitionedComputeStep;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelComputer;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.beta.pregel.Reducer;
import org.neo4j.gds.beta.pregel.ReducingMessenger;
import org.neo4j.gds.beta.pregel.SyncQueueMessenger;
import org.neo4j.gds.beta.pregel.context.MasterComputeContext;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PUBLIC, depluralize=true, deepImmutablesDetection=true)
public final class Pregel<CONFIG extends PregelConfig> {
    private final CONFIG config;
    private final PregelComputation<CONFIG> computation;
    private final Graph graph;
    private final NodeValue nodeValues;
    private final Messenger<?> messenger;
    private final PregelComputer<CONFIG> computer;
    private final ProgressTracker progressTracker;
    private final ExecutorService executor;

    public static <CONFIG extends PregelConfig> Pregel<CONFIG> create(Graph graph, CONFIG config, PregelComputation<CONFIG> computation, ExecutorService executor, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        ImmutablePregelConfig.copyOf(config);
        return new Pregel<CONFIG>(graph, config, computation, NodeValue.of(computation.schema(config), graph.nodeCount(), config.concurrency(), allocationTracker), executor, allocationTracker, progressTracker);
    }

    public static MemoryEstimation memoryEstimation(PregelSchema pregelSchema, boolean isQueueBased, boolean isAsync) {
        MemoryEstimations.Builder estimationBuilder = MemoryEstimations.builder(Pregel.class).perNode("vote bits", HugeAtomicBitSet::memoryEstimation).perThread("compute steps", MemoryEstimations.builder(PartitionedComputeStep.class).build()).add("node value", NodeValue.memoryEstimation(pregelSchema));
        if (isQueueBased) {
            if (isAsync) {
                estimationBuilder.add("message queues", AsyncQueueMessenger.memoryEstimation());
            } else {
                estimationBuilder.add("message queues", SyncQueueMessenger.memoryEstimation());
            }
        } else {
            estimationBuilder.add("message arrays", ReducingMessenger.memoryEstimation());
        }
        return estimationBuilder.build();
    }

    public static <CONFIG extends PregelConfig> Task progressTask(Graph graph, CONFIG config, String taskName) {
        return Tasks.iterativeDynamic((String)taskName, () -> List.of(Tasks.leaf((String)"Compute iteration", (long)graph.nodeCount()), Tasks.leaf((String)"Master compute iteration", (long)graph.nodeCount())), (int)config.maxIterations());
    }

    public static <CONFIG extends PregelConfig> Task progressTask(Graph graph, CONFIG config) {
        String configName = config.getClass().getSimpleName();
        String taskName = configName.replaceAll("(Mutate|Stream|Write|Stats)*Config", "");
        return Pregel.progressTask(graph, config, taskName);
    }

    private Pregel(Graph graph, CONFIG config, PregelComputation<CONFIG> computation, NodeValue initialNodeValue, ExecutorService executor, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        this.graph = graph;
        this.config = config;
        this.computation = computation;
        this.nodeValues = initialNodeValue;
        this.executor = executor;
        this.progressTracker = progressTracker;
        Optional<Reducer> reducer = computation.reducer();
        this.messenger = reducer.isPresent() ? new ReducingMessenger(graph, (PregelConfig)config, reducer.get(), allocationTracker) : (config.isAsynchronous() ? new AsyncQueueMessenger(graph.nodeCount(), allocationTracker) : new SyncQueueMessenger(graph.nodeCount(), allocationTracker));
        this.computer = PregelComputer.builder().graph(graph).computation(computation).config(config).nodeValues(this.nodeValues).messenger(this.messenger).voteBits(HugeAtomicBitSet.create((long)graph.nodeCount(), (AllocationTracker)allocationTracker)).executorService(config.useForkJoin() ? Pools.createForkJoinPool((int)config.concurrency()) : executor).progressTracker(progressTracker).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PregelResult run() {
        boolean didConverge = false;
        this.computer.initComputation();
        try {
            int iteration;
            this.progressTracker.beginSubTask();
            for (iteration = 0; iteration < this.config.maxIterations(); ++iteration) {
                try {
                    this.progressTracker.beginSubTask();
                    this.computer.initIteration(iteration);
                    this.messenger.initIteration(iteration);
                    this.computer.runIteration();
                }
                finally {
                    this.progressTracker.endSubTask();
                }
                try {
                    this.progressTracker.beginSubTask();
                    didConverge = this.runMasterComputeStep(iteration) || this.computer.hasConverged();
                }
                finally {
                    this.progressTracker.endSubTask();
                }
                if (didConverge) break;
            }
            PregelResult pregelResult = ImmutablePregelResult.builder().nodeValues(this.nodeValues).didConverge(didConverge).ranIterations(iteration).build();
            return pregelResult;
        }
        finally {
            this.progressTracker.endSubTask();
            this.computer.release();
        }
    }

    public void release() {
        this.progressTracker.release();
        this.messenger.release();
    }

    private boolean runMasterComputeStep(int iteration) {
        MasterComputeContext<CONFIG> context = new MasterComputeContext<CONFIG>(this.config, this.graph, iteration, this.nodeValues, this.executor);
        boolean didConverge = this.computation.masterCompute(context);
        return didConverge;
    }
}

