/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.Map;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Element;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public abstract class NodeValue {
    private final PregelSchema pregelSchema;
    private final Map<String, ValueType> propertyTypes;

    NodeValue(PregelSchema pregelSchema) {
        this.pregelSchema = pregelSchema;
        this.propertyTypes = pregelSchema.elements().stream().collect(Collectors.toMap(Element::propertyKey, Element::propertyType));
    }

    static NodeValue of(PregelSchema schema, long nodeCount, int concurrency, AllocationTracker allocationTracker) {
        Map<String, Object> properties = schema.elements().stream().collect(Collectors.toMap(Element::propertyKey, element -> NodeValue.initArray(element, nodeCount, concurrency, allocationTracker)));
        if (properties.size() == 1) {
            Element element2 = (Element)schema.elements().stream().findFirst().get();
            Object property = properties.values().stream().findFirst().get();
            return new SingleNodeValue(schema, element2, property);
        }
        return new CompositeNodeValue(schema, properties);
    }

    static MemoryEstimation memoryEstimation(PregelSchema pregelSchema) {
        return MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            MemoryEstimations.Builder builder = MemoryEstimations.builder();
            pregelSchema.elements().forEach(element -> {
                String entry = StringFormatting.formatWithLocale((String)"%s (%s)", (Object[])new Object[]{element.propertyKey(), element.propertyType()});
                switch (element.propertyType()) {
                    case LONG: {
                        builder.fixed(entry, HugeLongArray.memoryEstimation((long)dimensions.nodeCount()));
                        break;
                    }
                    case DOUBLE: {
                        builder.fixed(entry, HugeDoubleArray.memoryEstimation((long)dimensions.nodeCount()));
                        break;
                    }
                    case LONG_ARRAY: {
                        builder.add(entry, MemoryEstimations.builder().fixed(HugeObjectArray.class.getSimpleName(), MemoryUsage.sizeOfInstance(HugeObjectArray.class)).perNode("long[10]", nodeCount -> nodeCount * MemoryUsage.sizeOfLongArray((long)10L)).build());
                        break;
                    }
                    case DOUBLE_ARRAY: {
                        builder.add(entry, MemoryEstimations.builder().fixed(HugeObjectArray.class.getSimpleName(), MemoryUsage.sizeOfInstance(HugeObjectArray.class)).perNode("double[10]", nodeCount -> nodeCount * MemoryUsage.sizeOfDoubleArray((long)10L)).build());
                        break;
                    }
                    default: {
                        builder.add(entry, MemoryEstimations.empty());
                    }
                }
            });
            return builder.build();
        });
    }

    public PregelSchema schema() {
        return this.pregelSchema;
    }

    public abstract HugeDoubleArray doubleProperties(String var1);

    public abstract HugeLongArray longProperties(String var1);

    public abstract HugeObjectArray<long[]> longArrayProperties(String var1);

    public abstract HugeObjectArray<double[]> doubleArrayProperties(String var1);

    public double doubleValue(String key, long nodeId) {
        return this.doubleProperties(key).get(nodeId);
    }

    public long longValue(String key, long nodeId) {
        return this.longProperties(key).get(nodeId);
    }

    public long[] longArrayValue(String key, long nodeId) {
        HugeObjectArray<long[]> arrayProperties = this.longArrayProperties(key);
        return (long[])arrayProperties.get(nodeId);
    }

    public double[] doubleArrayValue(String key, long nodeId) {
        HugeObjectArray<double[]> arrayProperties = this.doubleArrayProperties(key);
        return (double[])arrayProperties.get(nodeId);
    }

    public void set(String key, long nodeId, double value) {
        this.doubleProperties(key).set(nodeId, value);
    }

    public void set(String key, long nodeId, long value) {
        this.longProperties(key).set(nodeId, value);
    }

    public void set(String key, long nodeId, long[] value) {
        this.longArrayProperties(key).set(nodeId, (Object)value);
    }

    public void set(String key, long nodeId, double[] value) {
        this.doubleArrayProperties(key).set(nodeId, (Object)value);
    }

    void checkProperty(String key, ValueType expectedType) {
        this.checkProperty(key, this.propertyTypes.get(key), expectedType);
    }

    private void checkProperty(String key, @Nullable ValueType actualType, ValueType expectedType) {
        if (actualType == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Property with key %s does not exist. Available properties are: %s", (Object[])new Object[]{key, this.propertyTypes.keySet()}));
        }
        if (actualType != expectedType) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Requested property type %s is not compatible with available property type %s for key %s. Available property types: %s", (Object[])new Object[]{expectedType, actualType, key, StringJoining.join(this.propertyTypes.entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()))}));
        }
    }

    private static Object initArray(Element element, long nodeCount, int concurrency, AllocationTracker allocationTracker) {
        switch (element.propertyType()) {
            case DOUBLE: {
                HugeDoubleArray doubleNodeValues = HugeDoubleArray.newArray((long)nodeCount, (AllocationTracker)allocationTracker);
                ParallelUtil.parallelStreamConsume((BaseStream)LongStream.range(0L, nodeCount), (int)concurrency, nodeIds -> nodeIds.forEach(nodeId -> doubleNodeValues.set(nodeId, Double.NaN)));
                return doubleNodeValues;
            }
            case LONG: {
                HugeLongArray longNodeValues = HugeLongArray.newArray((long)nodeCount, (AllocationTracker)allocationTracker);
                ParallelUtil.parallelStreamConsume((BaseStream)LongStream.range(0L, nodeCount), (int)concurrency, nodeIds -> nodeIds.forEach(nodeId -> longNodeValues.set(nodeId, Long.MIN_VALUE)));
                return longNodeValues;
            }
            case LONG_ARRAY: {
                return HugeObjectArray.newArray(long[].class, (long)nodeCount, (AllocationTracker)allocationTracker);
            }
            case DOUBLE_ARRAY: {
                return HugeObjectArray.newArray(double[].class, (long)nodeCount, (AllocationTracker)allocationTracker);
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported value type: %s", (Object[])new Object[]{element.propertyType()}));
    }

    public static final class CompositeNodeValue
    extends NodeValue {
        private final Map<String, Object> properties;

        CompositeNodeValue(PregelSchema pregelSchema, Map<String, Object> properties) {
            super(pregelSchema);
            this.properties = properties;
        }

        @Override
        public HugeDoubleArray doubleProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.DOUBLE);
            return (HugeDoubleArray)this.properties.get(propertyKey);
        }

        @Override
        public HugeLongArray longProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.LONG);
            return (HugeLongArray)this.properties.get(propertyKey);
        }

        @Override
        public HugeObjectArray<long[]> longArrayProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.LONG_ARRAY);
            return (HugeObjectArray)this.properties.get(propertyKey);
        }

        @Override
        public HugeObjectArray<double[]> doubleArrayProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.DOUBLE_ARRAY);
            return (HugeObjectArray)this.properties.get(propertyKey);
        }
    }

    public static final class SingleNodeValue
    extends NodeValue {
        private final Element element;
        private final Object property;

        SingleNodeValue(PregelSchema pregelSchema, Element element, Object property) {
            super(pregelSchema);
            this.element = element;
            this.property = property;
        }

        @Override
        public HugeDoubleArray doubleProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.DOUBLE);
            return (HugeDoubleArray)this.property;
        }

        @Override
        public HugeLongArray longProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.LONG);
            return (HugeLongArray)this.property;
        }

        @Override
        public HugeObjectArray<long[]> longArrayProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.LONG_ARRAY);
            return (HugeObjectArray)this.property;
        }

        @Override
        public HugeObjectArray<double[]> doubleArrayProperties(String propertyKey) {
            this.checkProperty(propertyKey, ValueType.DOUBLE_ARRAY);
            return (HugeObjectArray)this.property;
        }

        @Override
        void checkProperty(String key, ValueType expectedType) {
            ValueType actualType = this.element.propertyKey().equals(key) ? this.element.propertyType() : null;
            super.checkProperty(key, actualType, expectedType);
        }
    }
}

