/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Element;
import org.neo4j.gds.beta.pregel.PregelSchema;

@Generated(from="Element", generator="Immutables")
public final class ImmutableElement
implements Element {
    private final String propertyKey;
    private final ValueType propertyType;
    private final PregelSchema.Visibility visibility;

    private ImmutableElement(String propertyKey, ValueType propertyType, PregelSchema.Visibility visibility) {
        this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
        this.propertyType = Objects.requireNonNull(propertyType, "propertyType");
        this.visibility = Objects.requireNonNull(visibility, "visibility");
    }

    private ImmutableElement(ImmutableElement original, String propertyKey, ValueType propertyType, PregelSchema.Visibility visibility) {
        this.propertyKey = propertyKey;
        this.propertyType = propertyType;
        this.visibility = visibility;
    }

    @Override
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    public ValueType propertyType() {
        return this.propertyType;
    }

    @Override
    public PregelSchema.Visibility visibility() {
        return this.visibility;
    }

    public final ImmutableElement withPropertyKey(String value) {
        String newValue = Objects.requireNonNull(value, "propertyKey");
        if (this.propertyKey.equals(newValue)) {
            return this;
        }
        return new ImmutableElement(this, newValue, this.propertyType, this.visibility);
    }

    public final ImmutableElement withPropertyType(ValueType value) {
        if (this.propertyType == value) {
            return this;
        }
        ValueType newValue = Objects.requireNonNull(value, "propertyType");
        if (this.propertyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableElement(this, this.propertyKey, newValue, this.visibility);
    }

    public final ImmutableElement withVisibility(PregelSchema.Visibility value) {
        if (this.visibility == value) {
            return this;
        }
        PregelSchema.Visibility newValue = Objects.requireNonNull(value, "visibility");
        if (this.visibility.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableElement(this, this.propertyKey, this.propertyType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableElement && this.equalTo((ImmutableElement)another);
    }

    private boolean equalTo(ImmutableElement another) {
        return this.propertyKey.equals(another.propertyKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.propertyKey.hashCode();
        return h;
    }

    public String toString() {
        return "Element{propertyKey=" + this.propertyKey + "}";
    }

    public static Element of(String propertyKey, ValueType propertyType, PregelSchema.Visibility visibility) {
        return new ImmutableElement(propertyKey, propertyType, visibility);
    }

    public static Element copyOf(Element instance) {
        if (instance instanceof ImmutableElement) {
            return (ImmutableElement)instance;
        }
        return ImmutableElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Element", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROPERTY_KEY = 1L;
        private static final long INIT_BIT_PROPERTY_TYPE = 2L;
        private static final long INIT_BIT_VISIBILITY = 4L;
        private long initBits = 7L;
        private String propertyKey;
        private ValueType propertyType;
        private PregelSchema.Visibility visibility;

        private Builder() {
        }

        public final Builder from(Element instance) {
            Objects.requireNonNull(instance, "instance");
            this.propertyKey(instance.propertyKey());
            this.propertyType(instance.propertyType());
            this.visibility(instance.visibility());
            return this;
        }

        public final Builder propertyKey(String propertyKey) {
            this.propertyKey = Objects.requireNonNull(propertyKey, "propertyKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertyType(ValueType propertyType) {
            this.propertyType = Objects.requireNonNull(propertyType, "propertyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder visibility(PregelSchema.Visibility visibility) {
            this.visibility = Objects.requireNonNull(visibility, "visibility");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.propertyKey = null;
            this.propertyType = null;
            this.visibility = null;
            return this;
        }

        public Element build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableElement(null, this.propertyKey, this.propertyType, this.visibility);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("propertyKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertyType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("visibility");
            }
            return "Cannot build Element, some of required attributes are not set " + attributes;
        }
    }
}

