/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Generated;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelComputer;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

@Generated(from="PregelComputer.computer", generator="Immutables")
public final class ComputerBuilder<CONFIG extends PregelConfig> {
    private static final long INIT_BIT_GRAPH = 1L;
    private static final long INIT_BIT_COMPUTATION = 2L;
    private static final long INIT_BIT_CONFIG = 4L;
    private static final long INIT_BIT_NODE_VALUES = 8L;
    private static final long INIT_BIT_MESSENGER = 16L;
    private static final long INIT_BIT_VOTE_BITS = 32L;
    private static final long INIT_BIT_EXECUTOR_SERVICE = 64L;
    private static final long INIT_BIT_PROGRESS_TRACKER = 128L;
    private long initBits = 255L;
    private Graph graph;
    private PregelComputation<CONFIG> computation;
    private CONFIG config;
    private NodeValue nodeValues;
    private Messenger<?> messenger;
    private HugeAtomicBitSet voteBits;
    private ExecutorService executorService;
    private ProgressTracker progressTracker;

    public final ComputerBuilder<CONFIG> graph(Graph graph) {
        this.graph = Objects.requireNonNull(graph, "graph");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ComputerBuilder<CONFIG> computation(PregelComputation<CONFIG> computation) {
        this.computation = Objects.requireNonNull(computation, "computation");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final ComputerBuilder<CONFIG> config(CONFIG config) {
        this.config = (PregelConfig)Objects.requireNonNull(config, "config");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final ComputerBuilder<CONFIG> nodeValues(NodeValue nodeValues) {
        this.nodeValues = Objects.requireNonNull(nodeValues, "nodeValues");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final ComputerBuilder<CONFIG> messenger(Messenger<?> messenger) {
        this.messenger = Objects.requireNonNull(messenger, "messenger");
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public final ComputerBuilder<CONFIG> voteBits(HugeAtomicBitSet voteBits) {
        this.voteBits = Objects.requireNonNull(voteBits, "voteBits");
        this.initBits &= 0xFFFFFFFFFFFFFFDFL;
        return this;
    }

    public final ComputerBuilder<CONFIG> executorService(ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.initBits &= 0xFFFFFFFFFFFFFFBFL;
        return this;
    }

    public final ComputerBuilder<CONFIG> progressTracker(ProgressTracker progressTracker) {
        this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
        this.initBits &= 0xFFFFFFFFFFFFFF7FL;
        return this;
    }

    public PregelComputer<CONFIG> build() {
        this.checkRequiredAttributes();
        return PregelComputer.computer(this.graph, this.computation, this.config, this.nodeValues, this.messenger, this.voteBits, this.executorService, this.progressTracker);
    }

    private boolean graphIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean computationIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean configIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean nodeValuesIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean messengerIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private boolean voteBitsIsSet() {
        return (this.initBits & 0x20L) == 0L;
    }

    private boolean executorServiceIsSet() {
        return (this.initBits & 0x40L) == 0L;
    }

    private boolean progressTrackerIsSet() {
        return (this.initBits & 0x80L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.graphIsSet()) {
            attributes.add("graph");
        }
        if (!this.computationIsSet()) {
            attributes.add("computation");
        }
        if (!this.configIsSet()) {
            attributes.add("config");
        }
        if (!this.nodeValuesIsSet()) {
            attributes.add("nodeValues");
        }
        if (!this.messengerIsSet()) {
            attributes.add("messenger");
        }
        if (!this.voteBitsIsSet()) {
            attributes.add("voteBits");
        }
        if (!this.executorServiceIsSet()) {
            attributes.add("executorService");
        }
        if (!this.progressTrackerIsSet()) {
            attributes.add("progressTracker");
        }
        return "Cannot build computer, some of required attributes are not set " + attributes;
    }
}

