/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.pregel;

import org.neo4j.gds.beta.pregel.Messenger;
import org.neo4j.gds.beta.pregel.PrimitiveAsyncDoubleQueues;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;

class AsyncQueueMessenger
implements Messenger<PrimitiveAsyncDoubleQueues.Iterator> {
    private final PrimitiveAsyncDoubleQueues queues;

    AsyncQueueMessenger(long nodeCount, AllocationTracker allocationTracker) {
        this.queues = PrimitiveAsyncDoubleQueues.of(nodeCount, allocationTracker);
    }

    static MemoryEstimation memoryEstimation() {
        return PrimitiveAsyncDoubleQueues.memoryEstimation();
    }

    @Override
    public void initIteration(int iteration) {
        if (iteration > 0) {
            this.queues.compact();
        }
    }

    @Override
    public void sendTo(long targetNodeId, double message) {
        assert (!Double.isNaN(message));
        this.queues.push(targetNodeId, message);
    }

    @Override
    public PrimitiveAsyncDoubleQueues.Iterator messageIterator() {
        return new PrimitiveAsyncDoubleQueues.Iterator(this.queues);
    }

    @Override
    public void initMessageIterator(PrimitiveAsyncDoubleQueues.Iterator messageIterator, long nodeId, boolean isFirstIteration) {
        messageIterator.init(nodeId);
    }

    @Override
    public void release() {
        this.queues.release();
    }
}

