/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.regression;

import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.metrics.ModelCandidateStats;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyPredictPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.ImmutableNodeRegressionPipelineModelInfo;

@ValueClass
public interface NodeRegressionPipelineModelInfo
extends ToMapConvertible {
    public Map<Metric, Double> testMetrics();

    public Map<Metric, Double> outerTrainMetrics();

    public ModelCandidateStats bestCandidate();

    public NodePropertyPredictPipeline pipeline();

    @Value.Auxiliary
    @Value.Derived
    default public Map<String, Object> toMap() {
        return Map.of("bestParameters", this.bestCandidate().trainerConfig().toMapWithTrainerMethod(), "metrics", this.bestCandidate().renderMetrics(this.testMetrics(), this.outerTrainMetrics()), "pipeline", this.pipeline().toMap(), "nodePropertySteps", ToMapConvertible.toMap(this.pipeline().nodePropertySteps()), "featureProperties", this.pipeline().featureProperties());
    }

    public static ImmutableNodeRegressionPipelineModelInfo.Builder builder() {
        return ImmutableNodeRegressionPipelineModelInfo.builder();
    }

    public static NodeRegressionPipelineModelInfo of(Map<Metric, Double> testMetrics, Map<Metric, Double> outerTrainMetrics, ModelCandidateStats bestCandidate, NodePropertyPredictPipeline pipeline) {
        return ImmutableNodeRegressionPipelineModelInfo.of(testMetrics, outerTrainMetrics, bestCandidate, pipeline);
    }
}

