/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.regression;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.Regressor;
import org.neo4j.gds.ml.pipeline.nodePipeline.regression.NodeRegressionTrainResult;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="NodeRegressionTrainResult", generator="Immutables")
@Immutable
public final class ImmutableNodeRegressionTrainResult
implements NodeRegressionTrainResult {
    private final Regressor regressor;
    private final TrainingStatistics trainingStatistics;

    private ImmutableNodeRegressionTrainResult(Regressor regressor, TrainingStatistics trainingStatistics) {
        this.regressor = Objects.requireNonNull(regressor, "regressor");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
    }

    private ImmutableNodeRegressionTrainResult(ImmutableNodeRegressionTrainResult original, Regressor regressor, TrainingStatistics trainingStatistics) {
        this.regressor = regressor;
        this.trainingStatistics = trainingStatistics;
    }

    @Override
    public Regressor regressor() {
        return this.regressor;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    public final ImmutableNodeRegressionTrainResult withRegressor(Regressor value) {
        if (this.regressor == value) {
            return this;
        }
        Regressor newValue = Objects.requireNonNull(value, "regressor");
        return new ImmutableNodeRegressionTrainResult(this, newValue, this.trainingStatistics);
    }

    public final ImmutableNodeRegressionTrainResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableNodeRegressionTrainResult(this, this.regressor, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeRegressionTrainResult && this.equalTo((ImmutableNodeRegressionTrainResult)another);
    }

    private boolean equalTo(ImmutableNodeRegressionTrainResult another) {
        return this.regressor.equals(another.regressor) && this.trainingStatistics.equals(another.trainingStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.regressor.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "NodeRegressionTrainResult{regressor=" + this.regressor + ", trainingStatistics=" + this.trainingStatistics + "}";
    }

    public static NodeRegressionTrainResult of(Regressor regressor, TrainingStatistics trainingStatistics) {
        return new ImmutableNodeRegressionTrainResult(regressor, trainingStatistics);
    }

    public static NodeRegressionTrainResult copyOf(NodeRegressionTrainResult instance) {
        if (instance instanceof ImmutableNodeRegressionTrainResult) {
            return (ImmutableNodeRegressionTrainResult)instance;
        }
        return ImmutableNodeRegressionTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeRegressionTrainResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REGRESSOR = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Regressor regressor;
        @Nullable
        private TrainingStatistics trainingStatistics;

        private Builder() {
        }

        public final Builder from(NodeRegressionTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.regressor(instance.regressor());
            this.trainingStatistics(instance.trainingStatistics());
            return this;
        }

        public final Builder regressor(Regressor regressor) {
            this.regressor = Objects.requireNonNull(regressor, "regressor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.regressor = null;
            this.trainingStatistics = null;
            return this;
        }

        public NodeRegressionTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeRegressionTrainResult(null, this.regressor, this.trainingStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("regressor");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            return "Cannot build NodeRegressionTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

