/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.LongMultiSet;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.ImmutableLabelsAndClassCounts;

public final class LabelsAndClassCountsExtractor {
    private LabelsAndClassCountsExtractor() {
    }

    static LabelsAndClassCounts extractLabelsAndClassCounts(NodePropertyValues targetNodeProperty, long nodeCount) {
        HugeIntArray labels = HugeIntArray.newArray((long)nodeCount);
        LongMultiSet classCounts = LabelsAndClassCountsExtractor.extractClassCounts(targetNodeProperty, nodeCount);
        LocalIdMap localIdMap = LocalIdMap.ofSorted((long[])classCounts.keys());
        for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
            labels.set(nodeId, localIdMap.toMapped(targetNodeProperty.longValue(nodeId)));
        }
        return ImmutableLabelsAndClassCounts.of(labels, classCounts);
    }

    static LongMultiSet extractClassCounts(NodePropertyValues targetNodeProperty, long nodeCount) {
        LongMultiSet classCounts = new LongMultiSet();
        for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
            classCounts.add(targetNodeProperty.longValue(nodeId));
        }
        return classCounts;
    }

    @ValueClass
    static interface LabelsAndClassCounts {
        public HugeIntArray labels();

        public LongMultiSet classCounts();
    }
}

