/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.nodePipeline.classification.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.NodeClassificationPipelineModelInfo;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.NodeClassificationPipelineTrainConfig;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.train.NodeClassificationTrainResult;
import org.neo4j.gds.ml.training.TrainingStatistics;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationTrainResult.NodeClassificationModelResult", generator="Immutables")
@Immutable
public final class ImmutableNodeClassificationModelResult
implements NodeClassificationTrainResult.NodeClassificationModelResult {
    private final Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model;
    private final TrainingStatistics trainingStatistics;

    private ImmutableNodeClassificationModelResult(Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = Objects.requireNonNull(model, "model");
        this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
    }

    private ImmutableNodeClassificationModelResult(ImmutableNodeClassificationModelResult original, Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        this.model = model;
        this.trainingStatistics = trainingStatistics;
    }

    public Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model() {
        return this.model;
    }

    @Override
    public TrainingStatistics trainingStatistics() {
        return this.trainingStatistics;
    }

    public final ImmutableNodeClassificationModelResult withModel(Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> value) {
        if (this.model == value) {
            return this;
        }
        Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> newValue = Objects.requireNonNull(value, "model");
        return new ImmutableNodeClassificationModelResult(this, newValue, this.trainingStatistics);
    }

    public final ImmutableNodeClassificationModelResult withTrainingStatistics(TrainingStatistics value) {
        if (this.trainingStatistics == value) {
            return this;
        }
        TrainingStatistics newValue = Objects.requireNonNull(value, "trainingStatistics");
        return new ImmutableNodeClassificationModelResult(this, this.model, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationModelResult && this.equalTo((ImmutableNodeClassificationModelResult)another);
    }

    private boolean equalTo(ImmutableNodeClassificationModelResult another) {
        return this.model.equals(another.model) && this.trainingStatistics.equals(another.trainingStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.trainingStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "NodeClassificationModelResult{model=" + this.model + ", trainingStatistics=" + this.trainingStatistics + "}";
    }

    public static NodeClassificationTrainResult.NodeClassificationModelResult of(Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model, TrainingStatistics trainingStatistics) {
        return new ImmutableNodeClassificationModelResult(model, trainingStatistics);
    }

    public static NodeClassificationTrainResult.NodeClassificationModelResult copyOf(NodeClassificationTrainResult.NodeClassificationModelResult instance) {
        if (instance instanceof ImmutableNodeClassificationModelResult) {
            return (ImmutableNodeClassificationModelResult)instance;
        }
        return ImmutableNodeClassificationModelResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationTrainResult.NodeClassificationModelResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_TRAINING_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model;
        @Nullable
        private TrainingStatistics trainingStatistics;

        private Builder() {
        }

        public final Builder from(NodeClassificationTrainResult.NodeClassificationModelResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.model((Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo>)instance.model());
            this.trainingStatistics(instance.trainingStatistics());
            return this;
        }

        public final Builder model(Model<Classifier.ClassifierData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder trainingStatistics(TrainingStatistics trainingStatistics) {
            this.trainingStatistics = Objects.requireNonNull(trainingStatistics, "trainingStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.model = null;
            this.trainingStatistics = null;
            return this;
        }

        public NodeClassificationTrainResult.NodeClassificationModelResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationModelResult(null, this.model, this.trainingStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trainingStatistics");
            }
            return "Cannot build NodeClassificationModelResult, some of required attributes are not set " + attributes;
        }
    }
}

