/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.linkPipeline.linkfunctions.LinkFeatureStepConfiguration;

public final class LinkFeatureStepConfigurationImpl
implements LinkFeatureStepConfiguration {
    private List<String> nodeProperties;

    public LinkFeatureStepConfigurationImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeProperties = (List)CypherMapAccess.failOnNull((String)"nodeProperties", LinkFeatureStepConfiguration.fromObject(config.requireChecked("nodeProperties", Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public List<String> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public Collection<String> configKeys() {
        return Collections.singleton("nodeProperties");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(LinkFeatureStepConfiguration baseConfig) {
            Builder builder = new Builder();
            builder.nodeProperties(baseConfig.nodeProperties());
            return builder;
        }

        public Builder nodeProperties(Object nodeProperties) {
            this.config.put("nodeProperties", nodeProperties);
            return this;
        }

        public LinkFeatureStepConfiguration build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LinkFeatureStepConfigurationImpl((CypherMapAccess)config);
        }
    }
}

