/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionSplitConfig;

public final class LinkPredictionSplitConfigImpl
implements LinkPredictionSplitConfig {
    private int validationFolds;
    private double testFraction;
    private double trainFraction;
    private double negativeSamplingRatio;
    private Optional<String> negativeRelationshipType;

    public LinkPredictionSplitConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.validationFolds = config.getInt("validationFolds", LinkPredictionSplitConfig.super.validationFolds());
            CypherMapAccess.validateIntegerRange((String)"validationFolds", (int)this.validationFolds, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.testFraction = config.getDouble("testFraction", LinkPredictionSplitConfig.super.testFraction());
            CypherMapAccess.validateDoubleRange((String)"testFraction", (double)this.testFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.trainFraction = config.getDouble("trainFraction", LinkPredictionSplitConfig.super.trainFraction());
            CypherMapAccess.validateDoubleRange((String)"trainFraction", (double)this.trainFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingRatio = config.getDouble("negativeSamplingRatio", LinkPredictionSplitConfig.super.negativeSamplingRatio());
            CypherMapAccess.validateDoubleRange((String)"negativeSamplingRatio", (double)this.negativeSamplingRatio, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeRelationshipType = (Optional)CypherMapAccess.failOnNull((String)"negativeRelationshipType", (Object)config.getOptional("negativeRelationshipType", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int validationFolds() {
        return this.validationFolds;
    }

    @Override
    public double testFraction() {
        return this.testFraction;
    }

    @Override
    public double trainFraction() {
        return this.trainFraction;
    }

    @Override
    public double negativeSamplingRatio() {
        return this.negativeSamplingRatio;
    }

    @Override
    public Optional<String> negativeRelationshipType() {
        return this.negativeRelationshipType;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("validationFolds", this.validationFolds());
        map.put("testFraction", this.testFraction());
        map.put("trainFraction", this.trainFraction());
        map.put("negativeSamplingRatio", this.negativeSamplingRatio());
        this.negativeRelationshipType().ifPresent(negativeRelationshipType -> map.put("negativeRelationshipType", negativeRelationshipType));
        return map;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("validationFolds", "testFraction", "trainFraction", "negativeSamplingRatio", "negativeRelationshipType");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(LinkPredictionSplitConfig baseConfig) {
            Builder builder = new Builder();
            builder.validationFolds(baseConfig.validationFolds());
            builder.testFraction(baseConfig.testFraction());
            builder.trainFraction(baseConfig.trainFraction());
            builder.negativeSamplingRatio(baseConfig.negativeSamplingRatio());
            builder.negativeRelationshipType(baseConfig.negativeRelationshipType());
            return builder;
        }

        public Builder validationFolds(int validationFolds) {
            this.config.put("validationFolds", validationFolds);
            return this;
        }

        public Builder testFraction(double testFraction) {
            this.config.put("testFraction", testFraction);
            return this;
        }

        public Builder trainFraction(double trainFraction) {
            this.config.put("trainFraction", trainFraction);
            return this;
        }

        public Builder negativeSamplingRatio(double negativeSamplingRatio) {
            this.config.put("negativeSamplingRatio", negativeSamplingRatio);
            return this;
        }

        public Builder negativeRelationshipType(String negativeRelationshipType) {
            this.config.put("negativeRelationshipType", negativeRelationshipType);
            return this;
        }

        public Builder negativeRelationshipType(Optional<String> negativeRelationshipType) {
            negativeRelationshipType.ifPresent(actualnegativeRelationshipType -> this.config.put("negativeRelationshipType", actualnegativeRelationshipType));
            return this;
        }

        public LinkPredictionSplitConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LinkPredictionSplitConfigImpl((CypherMapAccess)config);
        }
    }
}

