/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.ml.pipeline.Pipeline;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkFeatureStep;

public final class LinkPredictionPredictPipeline
implements Pipeline<LinkFeatureStep> {
    public static final LinkPredictionPredictPipeline EMPTY = new LinkPredictionPredictPipeline(List.of(), List.of());
    private final List<ExecutableNodePropertyStep> nodePropertySteps;
    private final List<LinkFeatureStep> featureSteps;

    private LinkPredictionPredictPipeline(List<ExecutableNodePropertyStep> nodePropertySteps, List<LinkFeatureStep> featureSteps) {
        this.nodePropertySteps = nodePropertySteps;
        this.featureSteps = featureSteps;
    }

    public static LinkPredictionPredictPipeline from(Pipeline<LinkFeatureStep> pipeline) {
        return new LinkPredictionPredictPipeline(List.copyOf(pipeline.nodePropertySteps()), List.copyOf(pipeline.featureSteps()));
    }

    public static LinkPredictionPredictPipeline from(Stream<ExecutableNodePropertyStep> nodePropertySteps, Stream<LinkFeatureStep> linkFeatureSteps) {
        return new LinkPredictionPredictPipeline(nodePropertySteps.collect(Collectors.toList()), linkFeatureSteps.collect(Collectors.toList()));
    }

    public Map<String, Object> toMap() {
        return Map.of("nodePropertySteps", ToMapConvertible.toMap(this.nodePropertySteps()), "featureSteps", ToMapConvertible.toMap(this.featureSteps()));
    }

    @Override
    public List<ExecutableNodePropertyStep> nodePropertySteps() {
        return this.nodePropertySteps;
    }

    @Override
    public List<LinkFeatureStep> featureSteps() {
        return this.featureSteps;
    }

    @Override
    public void specificValidateBeforeExecution(GraphStore graphStore) {
    }
}

