/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.linkPipeline;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.pipeline.linkPipeline.ExpectedSetSizes;

@ParametersAreNonnullByDefault
@Generated(from="ExpectedSetSizes", generator="Immutables")
@Immutable
public final class ImmutableExpectedSetSizes
implements ExpectedSetSizes {
    private final long testSize;
    private final long featureInputSize;
    private final long trainSize;
    private final long testComplementSize;
    private final long validationFoldSize;

    private ImmutableExpectedSetSizes(long testSize, long featureInputSize, long trainSize, long testComplementSize, long validationFoldSize) {
        this.testSize = testSize;
        this.featureInputSize = featureInputSize;
        this.trainSize = trainSize;
        this.testComplementSize = testComplementSize;
        this.validationFoldSize = validationFoldSize;
    }

    @Override
    public long testSize() {
        return this.testSize;
    }

    @Override
    public long featureInputSize() {
        return this.featureInputSize;
    }

    @Override
    public long trainSize() {
        return this.trainSize;
    }

    @Override
    public long testComplementSize() {
        return this.testComplementSize;
    }

    @Override
    public long validationFoldSize() {
        return this.validationFoldSize;
    }

    public final ImmutableExpectedSetSizes withTestSize(long value) {
        if (this.testSize == value) {
            return this;
        }
        return new ImmutableExpectedSetSizes(value, this.featureInputSize, this.trainSize, this.testComplementSize, this.validationFoldSize);
    }

    public final ImmutableExpectedSetSizes withFeatureInputSize(long value) {
        if (this.featureInputSize == value) {
            return this;
        }
        return new ImmutableExpectedSetSizes(this.testSize, value, this.trainSize, this.testComplementSize, this.validationFoldSize);
    }

    public final ImmutableExpectedSetSizes withTrainSize(long value) {
        if (this.trainSize == value) {
            return this;
        }
        return new ImmutableExpectedSetSizes(this.testSize, this.featureInputSize, value, this.testComplementSize, this.validationFoldSize);
    }

    public final ImmutableExpectedSetSizes withTestComplementSize(long value) {
        if (this.testComplementSize == value) {
            return this;
        }
        return new ImmutableExpectedSetSizes(this.testSize, this.featureInputSize, this.trainSize, value, this.validationFoldSize);
    }

    public final ImmutableExpectedSetSizes withValidationFoldSize(long value) {
        if (this.validationFoldSize == value) {
            return this;
        }
        return new ImmutableExpectedSetSizes(this.testSize, this.featureInputSize, this.trainSize, this.testComplementSize, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpectedSetSizes && this.equalTo((ImmutableExpectedSetSizes)another);
    }

    private boolean equalTo(ImmutableExpectedSetSizes another) {
        return this.testSize == another.testSize && this.featureInputSize == another.featureInputSize && this.trainSize == another.trainSize && this.testComplementSize == another.testComplementSize && this.validationFoldSize == another.validationFoldSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.testSize);
        h += (h << 5) + Long.hashCode(this.featureInputSize);
        h += (h << 5) + Long.hashCode(this.trainSize);
        h += (h << 5) + Long.hashCode(this.testComplementSize);
        h += (h << 5) + Long.hashCode(this.validationFoldSize);
        return h;
    }

    public String toString() {
        return "ExpectedSetSizes{testSize=" + this.testSize + ", featureInputSize=" + this.featureInputSize + ", trainSize=" + this.trainSize + ", testComplementSize=" + this.testComplementSize + ", validationFoldSize=" + this.validationFoldSize + "}";
    }

    public static ExpectedSetSizes of(long testSize, long featureInputSize, long trainSize, long testComplementSize, long validationFoldSize) {
        return new ImmutableExpectedSetSizes(testSize, featureInputSize, trainSize, testComplementSize, validationFoldSize);
    }

    public static ExpectedSetSizes copyOf(ExpectedSetSizes instance) {
        if (instance instanceof ImmutableExpectedSetSizes) {
            return (ImmutableExpectedSetSizes)instance;
        }
        return ImmutableExpectedSetSizes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpectedSetSizes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEST_SIZE = 1L;
        private static final long INIT_BIT_FEATURE_INPUT_SIZE = 2L;
        private static final long INIT_BIT_TRAIN_SIZE = 4L;
        private static final long INIT_BIT_TEST_COMPLEMENT_SIZE = 8L;
        private static final long INIT_BIT_VALIDATION_FOLD_SIZE = 16L;
        private long initBits = 31L;
        private long testSize;
        private long featureInputSize;
        private long trainSize;
        private long testComplementSize;
        private long validationFoldSize;

        private Builder() {
        }

        public final Builder from(ExpectedSetSizes instance) {
            Objects.requireNonNull(instance, "instance");
            this.testSize(instance.testSize());
            this.featureInputSize(instance.featureInputSize());
            this.trainSize(instance.trainSize());
            this.testComplementSize(instance.testComplementSize());
            this.validationFoldSize(instance.validationFoldSize());
            return this;
        }

        public final Builder testSize(long testSize) {
            this.testSize = testSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder featureInputSize(long featureInputSize) {
            this.featureInputSize = featureInputSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder trainSize(long trainSize) {
            this.trainSize = trainSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder testComplementSize(long testComplementSize) {
            this.testComplementSize = testComplementSize;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder validationFoldSize(long validationFoldSize) {
            this.validationFoldSize = validationFoldSize;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.testSize = 0L;
            this.featureInputSize = 0L;
            this.trainSize = 0L;
            this.testComplementSize = 0L;
            this.validationFoldSize = 0L;
            return this;
        }

        public ExpectedSetSizes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpectedSetSizes(this.testSize, this.featureInputSize, this.trainSize, this.testComplementSize, this.validationFoldSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("testSize");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("featureInputSize");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("trainSize");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("testComplementSize");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("validationFoldSize");
            }
            return "Cannot build ExpectedSetSizes, some of required attributes are not set " + attributes;
        }
    }
}

