/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.pipeline.ExecutableNodePropertyStep;
import org.neo4j.gds.ml.pipeline.FeatureStep;
import org.neo4j.gds.utils.StringFormatting;

public interface Pipeline<FEATURE_STEP extends FeatureStep>
extends ToMapConvertible {
    public List<ExecutableNodePropertyStep> nodePropertySteps();

    public List<FEATURE_STEP> featureSteps();

    default public List<String> featureProperties() {
        return this.featureSteps().stream().flatMap(step -> step.inputNodeProperties().stream()).collect(Collectors.toList());
    }

    default public void validateBeforeExecution(GraphStore graphStore, Collection<NodeLabel> nodeLabels) {
        Set<String> invalidProperties = this.featurePropertiesMissingFromGraph(graphStore, nodeLabels);
        this.nodePropertySteps().stream().flatMap(step -> Stream.ofNullable((String)step.config().get("mutateProperty"))).forEach(invalidProperties::remove);
        if (!invalidProperties.isEmpty()) {
            throw Pipeline.missingNodePropertiesFromFeatureSteps(invalidProperties);
        }
        this.specificValidateBeforeExecution(graphStore);
    }

    public void specificValidateBeforeExecution(GraphStore var1);

    default public void validateFeatureProperties(GraphStore graphStore, Collection<NodeLabel> nodeLabels) {
        Set<String> invalidProperties = this.featurePropertiesMissingFromGraph(graphStore, nodeLabels);
        if (!invalidProperties.isEmpty()) {
            throw Pipeline.missingNodePropertiesFromFeatureSteps(invalidProperties);
        }
    }

    default public Set<String> featurePropertiesMissingFromGraph(GraphStore graphStore, Collection<NodeLabel> nodeLabels) {
        Collection graphProperties = graphStore.nodePropertyKeys(nodeLabels);
        return this.featureSteps().stream().flatMap(step -> step.inputNodeProperties().stream()).filter(property -> !graphProperties.contains(property)).collect(Collectors.toSet());
    }

    public static IllegalArgumentException missingNodePropertiesFromFeatureSteps(Set<String> invalidProperties) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node properties %s defined in the feature steps do not exist in the graph or part of the pipeline", (Object[])new Object[]{invalidProperties.stream().sorted().collect(Collectors.toList())}));
    }
}

