/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.pipeline.NodePropertyStepContextConfig;

public final class NodePropertyStepContextConfigImpl
implements NodePropertyStepContextConfig {
    private List<String> contextNodeLabels;
    private List<String> contextRelationshipTypes;

    public NodePropertyStepContextConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.contextNodeLabels = (List)CypherMapAccess.failOnNull((String)"contextNodeLabels", (Object)((List)config.getChecked("contextNodeLabels", NodePropertyStepContextConfig.super.contextNodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.contextRelationshipTypes = (List)CypherMapAccess.failOnNull((String)"contextRelationshipTypes", (Object)((List)config.getChecked("contextRelationshipTypes", NodePropertyStepContextConfig.super.contextRelationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public List<String> contextNodeLabels() {
        return this.contextNodeLabels;
    }

    @Override
    public List<String> contextRelationshipTypes() {
        return this.contextRelationshipTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(NodePropertyStepContextConfig baseConfig) {
            Builder builder = new Builder();
            builder.contextNodeLabels(baseConfig.contextNodeLabels());
            builder.contextRelationshipTypes(baseConfig.contextRelationshipTypes());
            return builder;
        }

        public Builder contextNodeLabels(List<String> contextNodeLabels) {
            this.config.put("contextNodeLabels", contextNodeLabels);
            return this;
        }

        public Builder contextRelationshipTypes(List<String> contextRelationshipTypes) {
            this.config.put("contextRelationshipTypes", contextRelationshipTypes);
            return this;
        }

        public NodePropertyStepContextConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new NodePropertyStepContextConfigImpl((CypherMapAccess)config);
        }
    }
}

