/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.ml.pipeline.PipelineGraphFilter;

@ParametersAreNonnullByDefault
@Generated(from="PipelineGraphFilter", generator="Immutables")
@Immutable
public final class ImmutablePipelineGraphFilter
implements PipelineGraphFilter {
    private final Collection<NodeLabel> nodeLabels;
    private final Collection<RelationshipType> relationshipTypes;

    private ImmutablePipelineGraphFilter(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        this.nodeLabels = Objects.requireNonNull(nodeLabels, "nodeLabels");
        this.relationshipTypes = Objects.requireNonNull(relationshipTypes, "relationshipTypes");
    }

    private ImmutablePipelineGraphFilter(Builder builder) {
        this.nodeLabels = builder.nodeLabels;
        this.relationshipTypes = builder.relationshipTypes != null ? builder.relationshipTypes : Objects.requireNonNull(PipelineGraphFilter.super.relationshipTypes(), "relationshipTypes");
    }

    private ImmutablePipelineGraphFilter(ImmutablePipelineGraphFilter original, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        this.nodeLabels = nodeLabels;
        this.relationshipTypes = relationshipTypes;
    }

    @Override
    public Collection<NodeLabel> nodeLabels() {
        return this.nodeLabels;
    }

    @Override
    public Collection<RelationshipType> relationshipTypes() {
        return this.relationshipTypes;
    }

    public final ImmutablePipelineGraphFilter withNodeLabels(Collection<NodeLabel> value) {
        if (this.nodeLabels == value) {
            return this;
        }
        Collection<NodeLabel> newValue = Objects.requireNonNull(value, "nodeLabels");
        return new ImmutablePipelineGraphFilter(this, newValue, this.relationshipTypes);
    }

    public final ImmutablePipelineGraphFilter withRelationshipTypes(Collection<RelationshipType> value) {
        if (this.relationshipTypes == value) {
            return this;
        }
        Collection<RelationshipType> newValue = Objects.requireNonNull(value, "relationshipTypes");
        return new ImmutablePipelineGraphFilter(this, this.nodeLabels, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePipelineGraphFilter && this.equalTo((ImmutablePipelineGraphFilter)another);
    }

    private boolean equalTo(ImmutablePipelineGraphFilter another) {
        return this.nodeLabels.equals(another.nodeLabels) && this.relationshipTypes.equals(another.relationshipTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        return h;
    }

    public String toString() {
        return "PipelineGraphFilter{nodeLabels=" + this.nodeLabels + ", relationshipTypes=" + this.relationshipTypes + "}";
    }

    public static PipelineGraphFilter of(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        return new ImmutablePipelineGraphFilter(nodeLabels, relationshipTypes);
    }

    public static PipelineGraphFilter copyOf(PipelineGraphFilter instance) {
        if (instance instanceof ImmutablePipelineGraphFilter) {
            return (ImmutablePipelineGraphFilter)instance;
        }
        return ImmutablePipelineGraphFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PipelineGraphFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE_LABELS = 1L;
        private long initBits = 1L;
        @Nullable
        private Collection<NodeLabel> nodeLabels;
        @Nullable
        private Collection<RelationshipType> relationshipTypes;

        private Builder() {
        }

        public final Builder from(PipelineGraphFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.nodeLabels(instance.nodeLabels());
            this.relationshipTypes(instance.relationshipTypes());
            return this;
        }

        public final Builder nodeLabels(Collection<NodeLabel> nodeLabels) {
            this.nodeLabels = Objects.requireNonNull(nodeLabels, "nodeLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipTypes(Collection<RelationshipType> relationshipTypes) {
            this.relationshipTypes = Objects.requireNonNull(relationshipTypes, "relationshipTypes");
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.nodeLabels = null;
            this.relationshipTypes = null;
            return this;
        }

        public PipelineGraphFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePipelineGraphFilter(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeLabels");
            }
            return "Cannot build PipelineGraphFilter, some of required attributes are not set " + attributes;
        }
    }
}

