/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;

@ParametersAreNonnullByDefault
@Generated(from="PipelineCatalog.PipelineCatalogEntry", generator="Immutables")
@Immutable
public final class ImmutablePipelineCatalogEntry
implements PipelineCatalog.PipelineCatalogEntry {
    private final String pipelineName;
    private final TrainingPipeline<?> pipeline;

    private ImmutablePipelineCatalogEntry(String pipelineName, TrainingPipeline<?> pipeline) {
        this.pipelineName = Objects.requireNonNull(pipelineName, "pipelineName");
        this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
    }

    private ImmutablePipelineCatalogEntry(ImmutablePipelineCatalogEntry original, String pipelineName, TrainingPipeline<?> pipeline) {
        this.pipelineName = pipelineName;
        this.pipeline = pipeline;
    }

    @Override
    public String pipelineName() {
        return this.pipelineName;
    }

    @Override
    public TrainingPipeline<?> pipeline() {
        return this.pipeline;
    }

    public final ImmutablePipelineCatalogEntry withPipelineName(String value) {
        String newValue = Objects.requireNonNull(value, "pipelineName");
        if (this.pipelineName.equals(newValue)) {
            return this;
        }
        return new ImmutablePipelineCatalogEntry(this, newValue, this.pipeline);
    }

    public final ImmutablePipelineCatalogEntry withPipeline(TrainingPipeline<?> value) {
        if (this.pipeline == value) {
            return this;
        }
        TrainingPipeline<?> newValue = Objects.requireNonNull(value, "pipeline");
        return new ImmutablePipelineCatalogEntry(this, this.pipelineName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePipelineCatalogEntry && this.equalTo((ImmutablePipelineCatalogEntry)another);
    }

    private boolean equalTo(ImmutablePipelineCatalogEntry another) {
        return this.pipelineName.equals(another.pipelineName) && this.pipeline.equals(another.pipeline);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pipelineName.hashCode();
        h += (h << 5) + this.pipeline.hashCode();
        return h;
    }

    public String toString() {
        return "PipelineCatalogEntry{pipelineName=" + this.pipelineName + ", pipeline=" + this.pipeline + "}";
    }

    public static PipelineCatalog.PipelineCatalogEntry of(String pipelineName, TrainingPipeline<?> pipeline) {
        return new ImmutablePipelineCatalogEntry(pipelineName, pipeline);
    }

    public static PipelineCatalog.PipelineCatalogEntry copyOf(PipelineCatalog.PipelineCatalogEntry instance) {
        if (instance instanceof ImmutablePipelineCatalogEntry) {
            return (ImmutablePipelineCatalogEntry)instance;
        }
        return ImmutablePipelineCatalogEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PipelineCatalog.PipelineCatalogEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PIPELINE_NAME = 1L;
        private static final long INIT_BIT_PIPELINE = 2L;
        private long initBits = 3L;
        @Nullable
        private String pipelineName;
        @Nullable
        private TrainingPipeline<?> pipeline;

        private Builder() {
        }

        public final Builder from(PipelineCatalog.PipelineCatalogEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.pipelineName(instance.pipelineName());
            this.pipeline(instance.pipeline());
            return this;
        }

        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = Objects.requireNonNull(pipelineName, "pipelineName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pipeline(TrainingPipeline<?> pipeline) {
            this.pipeline = Objects.requireNonNull(pipeline, "pipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.pipelineName = null;
            this.pipeline = null;
            return this;
        }

        public PipelineCatalog.PipelineCatalogEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePipelineCatalogEntry(null, this.pipelineName, this.pipeline);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pipelineName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pipeline");
            }
            return "Cannot build PipelineCatalogEntry, some of required attributes are not set " + attributes;
        }
    }
}

