/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ElementTypeValidator;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.executor.ExecutionContext;

public interface ExecutableNodePropertyStep
extends ToMapConvertible {
    public void execute(ExecutionContext var1, String var2, Collection<NodeLabel> var3, Collection<RelationshipType> var4);

    public Map<String, Object> config();

    default public List<String> contextNodeLabels() {
        return List.of();
    }

    default public Set<NodeLabel> featureInputNodeLabels(GraphStore graphStore, Collection<NodeLabel> nodeLabels) {
        return Stream.concat(nodeLabels.stream(), ElementTypeValidator.resolve((GraphStore)graphStore, this.contextNodeLabels()).stream()).collect(Collectors.toSet());
    }

    default public List<String> contextRelationshipTypes() {
        return List.of();
    }

    default public Set<RelationshipType> featureInputRelationshipTypes(GraphStore graphStore, Collection<RelationshipType> relationshipTypes, Set<RelationshipType> availableRelationshipTypesForNodeProperties) {
        return Stream.concat(relationshipTypes.stream(), ElementTypeValidator.resolveTypes((GraphStore)graphStore, this.contextRelationshipTypes()).stream().filter(availableRelationshipTypesForNodeProperties::contains)).collect(Collectors.toSet());
    }

    public String procName();

    default public String rootTaskName() {
        return this.procName();
    }

    public MemoryEstimation estimate(ModelCatalog var1, String var2, List<String> var3, List<String> var4);

    public String mutateNodeProperty();
}

