/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.Nullable;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;

public abstract class CompositeNodeCursor
extends DefaultCloseListenable
implements Cursor {
    private final PriorityQueue<NodeLabelIndexCursor> cursorQueue;
    private boolean repopulateCursorQueue;
    private final List<NodeLabelIndexCursor> cursors;
    private NodeLabelIndexCursor current;
    private final LongArrayList currentLabels;
    private final IdentityHashMap<NodeLabelIndexCursor, Integer> cursorLabelIdMapping;
    private boolean closed = false;

    protected CompositeNodeCursor(List<NodeLabelIndexCursor> cursors, int[] labelIds) {
        this.cursors = cursors;
        this.cursorQueue = new PriorityQueue<NodeLabelIndexCursor>(cursors.size(), Comparator.comparingLong(NodeIndexCursor::nodeReference));
        this.repopulateCursorQueue = true;
        this.cursorLabelIdMapping = new IdentityHashMap();
        this.currentLabels = new LongArrayList();
        for (int i = 0; i < cursors.size(); ++i) {
            this.cursorLabelIdMapping.put(cursors.get(i), labelIds[i]);
        }
    }

    @Nullable
    public NodeLabelIndexCursor getCursor(int index) {
        return this.cursors.get(index);
    }

    public void removeCursor(int index) {
        NodeLabelIndexCursor cursor = this.cursors.get(index);
        if (cursor != null) {
            cursor.close();
            this.cursors.set(index, null);
        }
    }

    public long[] currentLabels() {
        return this.currentLabels.toArray();
    }

    public long nodeReference() {
        return this.current.nodeReference();
    }

    public boolean next() {
        if (this.repopulateCursorQueue) {
            this.repopulateCursorQueue = false;
            this.cursors.forEach(cursor -> {
                if (cursor != null && cursor.next()) {
                    this.cursorQueue.add((NodeLabelIndexCursor)cursor);
                }
            });
        }
        if (this.current != null && this.current.next()) {
            this.cursorQueue.add(this.current);
        }
        if (this.cursorQueue.isEmpty()) {
            this.current = null;
            this.repopulateCursorQueue = true;
            return false;
        }
        this.current = this.cursorQueue.poll();
        this.currentLabels.clear();
        this.currentLabels.add((long)this.cursorLabelIdMapping.get(this.current).intValue());
        NodeLabelIndexCursor next = this.cursorQueue.peek();
        while (next != null && next.nodeReference() == this.current.nodeReference()) {
            this.cursorQueue.poll();
            this.currentLabels.add((long)this.cursorLabelIdMapping.get(next).intValue());
            if (next.next()) {
                this.cursorQueue.add(next);
            }
            next = this.cursorQueue.peek();
        }
        return true;
    }

    public void setTracer(KernelReadTracer tracer) {
        this.cursors.forEach(cursor -> {
            if (cursor != null) {
                cursor.setTracer(tracer);
            }
        });
    }

    public void removeTracer() {
        this.cursors.forEach(cursor -> {
            if (cursor != null) {
                cursor.removeTracer();
            }
        });
    }

    public void closeCursor() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.closeInternal();
        if (this.closeListener != null) {
            this.closeListener.onClosed((AutoCloseablePlus)this);
        }
    }

    public void closeInternal() {
        this.cursors.forEach(cursor -> {
            if (cursor != null) {
                cursor.closeInternal();
            }
        });
    }

    public boolean isClosed() {
        return this.closed;
    }
}

