/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.util;

import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.StringFormatting;

public final class TrainingSetWarnings {
    private static final int RECOMMENDED_MIN_ELEMENTS_PER_SET = 5;

    private TrainingSetWarnings() {
    }

    public static void warnForSmallNodeSets(long trainSetSize, long testSetSize, long validationFolds, ProgressTracker progressTracker) {
        TrainingSetWarnings.warnForSmallSets(trainSetSize, testSetSize, validationFolds, "node", progressTracker);
    }

    public static void warnForSmallRelationshipSets(long trainSetSize, long testSetSize, long validationFolds, ProgressTracker progressTracker) {
        TrainingSetWarnings.warnForSmallSets(trainSetSize, testSetSize, validationFolds, "relationship", progressTracker);
    }

    private static void warnForSmallSets(long trainSetSize, long testSetSize, long validationFolds, String elementType, ProgressTracker progressTracker) {
        long validationSetSize;
        progressTracker.logInfo("Train set size is " + trainSetSize);
        progressTracker.logInfo("Test set size is " + testSetSize);
        if (testSetSize < 5L) {
            progressTracker.logWarning(StringFormatting.formatWithLocale((String)"The specified `testFraction` leads to a very small test set with only %d %s(s). Proceeding with such a small set might lead to unreliable results.", (Object[])new Object[]{testSetSize, elementType}));
        }
        if ((validationSetSize = trainSetSize / validationFolds) < 5L) {
            progressTracker.logWarning(StringFormatting.formatWithLocale((String)"The specified `validationFolds` leads to very small validation sets with only %d %s(s). Proceeding with such small sets might lead to unreliable results.", (Object[])new Object[]{validationSetSize, elementType}));
        }
    }
}

