/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.ml.splitting.SplitRelationshipsBaseConfig;

public final class SplitRelationshipsBaseConfigImpl
implements SplitRelationshipsBaseConfig {
    private double holdoutFraction;
    private double negativeSamplingRatio;
    private List<String> sourceNodeLabels;
    private List<String> targetNodeLabels;
    private RelationshipType holdoutRelationshipType;
    private RelationshipType remainingRelationshipType;
    private List<String> nonNegativeRelationshipTypes;
    private List<String> relationshipTypes;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private Optional<Long> randomSeed;
    private Optional<String> relationshipWeightProperty;

    public SplitRelationshipsBaseConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.holdoutFraction = config.requireDouble("holdoutFraction");
            CypherMapAccess.validateDoubleRange((String)"holdoutFraction", (double)this.holdoutFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingRatio = config.requireDouble("negativeSamplingRatio");
            CypherMapAccess.validateDoubleRange((String)"negativeSamplingRatio", (double)this.negativeSamplingRatio, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodeLabels = (List)CypherMapAccess.failOnNull((String)"sourceNodeLabels", (Object)((List)config.getChecked("sourceNodeLabels", SplitRelationshipsBaseConfig.super.sourceNodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodeLabels = (List)CypherMapAccess.failOnNull((String)"targetNodeLabels", (Object)((List)config.getChecked("targetNodeLabels", SplitRelationshipsBaseConfig.super.targetNodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.holdoutRelationshipType = (RelationshipType)CypherMapAccess.failOnNull((String)"holdoutRelationshipType", (Object)RelationshipType.of((String)config.requireString("holdoutRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.remainingRelationshipType = (RelationshipType)CypherMapAccess.failOnNull((String)"remainingRelationshipType", (Object)RelationshipType.of((String)config.requireString("remainingRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nonNegativeRelationshipTypes = (List)CypherMapAccess.failOnNull((String)"nonNegativeRelationshipTypes", (Object)((List)config.getChecked("nonNegativeRelationshipTypes", SplitRelationshipsBaseConfig.super.nonNegativeRelationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)SplitRelationshipsBaseConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", SplitRelationshipsBaseConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", SplitRelationshipsBaseConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", SplitRelationshipsBaseConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)SplitRelationshipsBaseConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double holdoutFraction() {
        return this.holdoutFraction;
    }

    @Override
    public double negativeSamplingRatio() {
        return this.negativeSamplingRatio;
    }

    @Override
    public List<String> sourceNodeLabels() {
        return this.sourceNodeLabels;
    }

    @Override
    public List<String> targetNodeLabels() {
        return this.targetNodeLabels;
    }

    @Override
    public RelationshipType holdoutRelationshipType() {
        return this.holdoutRelationshipType;
    }

    @Override
    public RelationshipType remainingRelationshipType() {
        return this.remainingRelationshipType;
    }

    @Override
    public List<String> nonNegativeRelationshipTypes() {
        return this.nonNegativeRelationshipTypes;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateRemainingRelType(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateHoldOutRelType(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNonNegativeRelTypesExist(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("holdoutFraction", "negativeSamplingRatio", "sourceNodeLabels", "targetNodeLabels", "holdoutRelationshipType", "remainingRelationshipType", "nonNegativeRelationshipTypes", "relationshipTypes", "username", "sudo", "logProgress", "concurrency", "jobId", "randomSeed", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("holdoutFraction", this.holdoutFraction());
        map.put("negativeSamplingRatio", this.negativeSamplingRatio());
        map.put("sourceNodeLabels", this.sourceNodeLabels());
        map.put("targetNodeLabels", this.targetNodeLabels());
        map.put("holdoutRelationshipType", RelationshipType.toString((RelationshipType)this.holdoutRelationshipType()));
        map.put("remainingRelationshipType", RelationshipType.toString((RelationshipType)this.remainingRelationshipType()));
        map.put("nonNegativeRelationshipTypes", this.nonNegativeRelationshipTypes());
        map.put("relationshipTypes", this.relationshipTypes());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(SplitRelationshipsBaseConfig baseConfig) {
            Builder builder = new Builder();
            builder.holdoutFraction(baseConfig.holdoutFraction());
            builder.negativeSamplingRatio(baseConfig.negativeSamplingRatio());
            builder.sourceNodeLabels(baseConfig.sourceNodeLabels());
            builder.targetNodeLabels(baseConfig.targetNodeLabels());
            builder.holdoutRelationshipType(RelationshipType.toString((RelationshipType)baseConfig.holdoutRelationshipType()));
            builder.remainingRelationshipType(RelationshipType.toString((RelationshipType)baseConfig.remainingRelationshipType()));
            builder.nonNegativeRelationshipTypes(baseConfig.nonNegativeRelationshipTypes());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.randomSeed(baseConfig.randomSeed());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            return builder;
        }

        public Builder holdoutFraction(double holdoutFraction) {
            this.config.put("holdoutFraction", holdoutFraction);
            return this;
        }

        public Builder negativeSamplingRatio(double negativeSamplingRatio) {
            this.config.put("negativeSamplingRatio", negativeSamplingRatio);
            return this;
        }

        public Builder sourceNodeLabels(List<String> sourceNodeLabels) {
            this.config.put("sourceNodeLabels", sourceNodeLabels);
            return this;
        }

        public Builder targetNodeLabels(List<String> targetNodeLabels) {
            this.config.put("targetNodeLabels", targetNodeLabels);
            return this;
        }

        public Builder holdoutRelationshipType(String holdoutRelationshipType) {
            this.config.put("holdoutRelationshipType", holdoutRelationshipType);
            return this;
        }

        public Builder remainingRelationshipType(String remainingRelationshipType) {
            this.config.put("remainingRelationshipType", remainingRelationshipType);
            return this;
        }

        public Builder nonNegativeRelationshipTypes(List<String> nonNegativeRelationshipTypes) {
            this.config.put("nonNegativeRelationshipTypes", nonNegativeRelationshipTypes);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public SplitRelationshipsBaseConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new SplitRelationshipsBaseConfigImpl((CypherMapAccess)config);
        }
    }
}

