/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ElementTypeValidator;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.utils.StringFormatting;

@Configuration
public interface SplitRelationshipsBaseConfig
extends AlgoBaseConfig,
RandomSeedConfig,
RelationshipWeightConfig {
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    public double holdoutFraction();

    @Configuration.DoubleRange(min=0.0)
    public double negativeSamplingRatio();

    default public List<String> sourceNodeLabels() {
        return List.of("*");
    }

    default public List<String> targetNodeLabels() {
        return List.of("*");
    }

    @Configuration.Ignore
    default public List<String> nodeLabels() {
        return Stream.of(this.sourceNodeLabels(), this.targetNodeLabels()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Configuration.ConvertWith(method="org.neo4j.gds.RelationshipType#of", inverse="__USE_TO_MAP_METHOD__")
    @Configuration.ToMapValue(value="org.neo4j.gds.RelationshipType#toString")
    public RelationshipType holdoutRelationshipType();

    @Configuration.ConvertWith(method="org.neo4j.gds.RelationshipType#of", inverse="__USE_TO_MAP_METHOD__")
    @Configuration.ToMapValue(value="org.neo4j.gds.RelationshipType#toString")
    public RelationshipType remainingRelationshipType();

    @Value.Default
    default public List<String> nonNegativeRelationshipTypes() {
        return List.of();
    }

    @Configuration.Ignore
    @Value.Derived
    default public List<String> superRelationshipTypes() {
        return Stream.of(this.relationshipTypes(), this.nonNegativeRelationshipTypes()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void validateRemainingRelType(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.validateTypeDoesNotExist(graphStore, this.remainingRelationshipType(), "remainingRelationshipType");
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void validateHoldOutRelType(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.validateTypeDoesNotExist(graphStore, this.holdoutRelationshipType(), "holdoutRelationshipType");
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void validateNonNegativeRelTypesExist(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ElementTypeValidator.resolveAndValidateTypes((GraphStore)graphStore, this.nonNegativeRelationshipTypes(), (String)"`nonNegativeRelationshipTypes`");
    }

    @Configuration.Ignore
    default public void validateTypeDoesNotExist(GraphStore graphStore, RelationshipType type, String name) {
        if (graphStore.hasRelationshipType(type)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The specified `%s` of `%s` already exists in the in-memory graph.", (Object[])new Object[]{name, type.name()}));
        }
    }
}

