/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.ReadOnlyHugeLongArray;
import org.neo4j.gds.ml.splitting.TrainingExamplesSplit;

@Generated(from="TrainingExamplesSplit", generator="Immutables")
public final class ImmutableTrainingExamplesSplit
implements TrainingExamplesSplit {
    private final ReadOnlyHugeLongArray trainSet;
    private final ReadOnlyHugeLongArray testSet;

    private ImmutableTrainingExamplesSplit(ReadOnlyHugeLongArray trainSet, ReadOnlyHugeLongArray testSet) {
        this.trainSet = Objects.requireNonNull(trainSet, "trainSet");
        this.testSet = Objects.requireNonNull(testSet, "testSet");
    }

    private ImmutableTrainingExamplesSplit(ImmutableTrainingExamplesSplit original, ReadOnlyHugeLongArray trainSet, ReadOnlyHugeLongArray testSet) {
        this.trainSet = trainSet;
        this.testSet = testSet;
    }

    @Override
    public ReadOnlyHugeLongArray trainSet() {
        return this.trainSet;
    }

    @Override
    public ReadOnlyHugeLongArray testSet() {
        return this.testSet;
    }

    public final ImmutableTrainingExamplesSplit withTrainSet(ReadOnlyHugeLongArray value) {
        if (this.trainSet == value) {
            return this;
        }
        ReadOnlyHugeLongArray newValue = Objects.requireNonNull(value, "trainSet");
        return new ImmutableTrainingExamplesSplit(this, newValue, this.testSet);
    }

    public final ImmutableTrainingExamplesSplit withTestSet(ReadOnlyHugeLongArray value) {
        if (this.testSet == value) {
            return this;
        }
        ReadOnlyHugeLongArray newValue = Objects.requireNonNull(value, "testSet");
        return new ImmutableTrainingExamplesSplit(this, this.trainSet, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrainingExamplesSplit && this.equalTo(0, (ImmutableTrainingExamplesSplit)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrainingExamplesSplit another) {
        return this.trainSet.equals(another.trainSet) && this.testSet.equals(another.testSet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.trainSet.hashCode();
        h += (h << 5) + this.testSet.hashCode();
        return h;
    }

    public String toString() {
        return "TrainingExamplesSplit{trainSet=" + this.trainSet + ", testSet=" + this.testSet + "}";
    }

    public static TrainingExamplesSplit of(ReadOnlyHugeLongArray trainSet, ReadOnlyHugeLongArray testSet) {
        return new ImmutableTrainingExamplesSplit(trainSet, testSet);
    }

    public static TrainingExamplesSplit copyOf(TrainingExamplesSplit instance) {
        if (instance instanceof ImmutableTrainingExamplesSplit) {
            return (ImmutableTrainingExamplesSplit)instance;
        }
        return ImmutableTrainingExamplesSplit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrainingExamplesSplit", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TRAIN_SET = 1L;
        private static final long INIT_BIT_TEST_SET = 2L;
        private long initBits = 3L;
        private ReadOnlyHugeLongArray trainSet;
        private ReadOnlyHugeLongArray testSet;

        private Builder() {
        }

        public final Builder from(TrainingExamplesSplit instance) {
            Objects.requireNonNull(instance, "instance");
            this.trainSet(instance.trainSet());
            this.testSet(instance.testSet());
            return this;
        }

        public final Builder trainSet(ReadOnlyHugeLongArray trainSet) {
            this.trainSet = Objects.requireNonNull(trainSet, "trainSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder testSet(ReadOnlyHugeLongArray testSet) {
            this.testSet = Objects.requireNonNull(testSet, "testSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.trainSet = null;
            this.testSet = null;
            return this;
        }

        public TrainingExamplesSplit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrainingExamplesSplit(null, this.trainSet, this.testSet);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("trainSet");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("testSet");
            }
            return "Cannot build TrainingExamplesSplit, some of required attributes are not set " + attributes;
        }
    }
}

