/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.ml.splitting.EdgeSplitter;

@Generated(from="EdgeSplitter.SplitResult", generator="Immutables")
public final class ImmutableSplitResult
implements EdgeSplitter.SplitResult {
    private final RelationshipsBuilder remainingRels;
    private final long remainingRelCount;
    private final RelationshipsBuilder selectedRels;
    private final long selectedRelCount;

    private ImmutableSplitResult(RelationshipsBuilder remainingRels, long remainingRelCount, RelationshipsBuilder selectedRels, long selectedRelCount) {
        this.remainingRels = Objects.requireNonNull(remainingRels, "remainingRels");
        this.remainingRelCount = remainingRelCount;
        this.selectedRels = Objects.requireNonNull(selectedRels, "selectedRels");
        this.selectedRelCount = selectedRelCount;
    }

    private ImmutableSplitResult(ImmutableSplitResult original, RelationshipsBuilder remainingRels, long remainingRelCount, RelationshipsBuilder selectedRels, long selectedRelCount) {
        this.remainingRels = remainingRels;
        this.remainingRelCount = remainingRelCount;
        this.selectedRels = selectedRels;
        this.selectedRelCount = selectedRelCount;
    }

    @Override
    public RelationshipsBuilder remainingRels() {
        return this.remainingRels;
    }

    @Override
    public long remainingRelCount() {
        return this.remainingRelCount;
    }

    @Override
    public RelationshipsBuilder selectedRels() {
        return this.selectedRels;
    }

    @Override
    public long selectedRelCount() {
        return this.selectedRelCount;
    }

    public final ImmutableSplitResult withRemainingRels(RelationshipsBuilder value) {
        if (this.remainingRels == value) {
            return this;
        }
        RelationshipsBuilder newValue = Objects.requireNonNull(value, "remainingRels");
        return new ImmutableSplitResult(this, newValue, this.remainingRelCount, this.selectedRels, this.selectedRelCount);
    }

    public final ImmutableSplitResult withRemainingRelCount(long value) {
        if (this.remainingRelCount == value) {
            return this;
        }
        return new ImmutableSplitResult(this, this.remainingRels, value, this.selectedRels, this.selectedRelCount);
    }

    public final ImmutableSplitResult withSelectedRels(RelationshipsBuilder value) {
        if (this.selectedRels == value) {
            return this;
        }
        RelationshipsBuilder newValue = Objects.requireNonNull(value, "selectedRels");
        return new ImmutableSplitResult(this, this.remainingRels, this.remainingRelCount, newValue, this.selectedRelCount);
    }

    public final ImmutableSplitResult withSelectedRelCount(long value) {
        if (this.selectedRelCount == value) {
            return this;
        }
        return new ImmutableSplitResult(this, this.remainingRels, this.remainingRelCount, this.selectedRels, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSplitResult && this.equalTo(0, (ImmutableSplitResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableSplitResult another) {
        return this.remainingRels.equals(another.remainingRels) && this.remainingRelCount == another.remainingRelCount && this.selectedRels.equals(another.selectedRels) && this.selectedRelCount == another.selectedRelCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.remainingRels.hashCode();
        h += (h << 5) + Long.hashCode(this.remainingRelCount);
        h += (h << 5) + this.selectedRels.hashCode();
        h += (h << 5) + Long.hashCode(this.selectedRelCount);
        return h;
    }

    public String toString() {
        return "SplitResult{remainingRels=" + this.remainingRels + ", remainingRelCount=" + this.remainingRelCount + ", selectedRels=" + this.selectedRels + ", selectedRelCount=" + this.selectedRelCount + "}";
    }

    public static EdgeSplitter.SplitResult of(RelationshipsBuilder remainingRels, long remainingRelCount, RelationshipsBuilder selectedRels, long selectedRelCount) {
        return new ImmutableSplitResult(remainingRels, remainingRelCount, selectedRels, selectedRelCount);
    }

    public static EdgeSplitter.SplitResult copyOf(EdgeSplitter.SplitResult instance) {
        if (instance instanceof ImmutableSplitResult) {
            return (ImmutableSplitResult)instance;
        }
        return ImmutableSplitResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EdgeSplitter.SplitResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REMAINING_RELS = 1L;
        private static final long INIT_BIT_REMAINING_REL_COUNT = 2L;
        private static final long INIT_BIT_SELECTED_RELS = 4L;
        private static final long INIT_BIT_SELECTED_REL_COUNT = 8L;
        private long initBits = 15L;
        private RelationshipsBuilder remainingRels;
        private long remainingRelCount;
        private RelationshipsBuilder selectedRels;
        private long selectedRelCount;

        private Builder() {
        }

        public final Builder from(EdgeSplitter.SplitResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.remainingRels(instance.remainingRels());
            this.remainingRelCount(instance.remainingRelCount());
            this.selectedRels(instance.selectedRels());
            this.selectedRelCount(instance.selectedRelCount());
            return this;
        }

        public final Builder remainingRels(RelationshipsBuilder remainingRels) {
            this.remainingRels = Objects.requireNonNull(remainingRels, "remainingRels");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder remainingRelCount(long remainingRelCount) {
            this.remainingRelCount = remainingRelCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder selectedRels(RelationshipsBuilder selectedRels) {
            this.selectedRels = Objects.requireNonNull(selectedRels, "selectedRels");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder selectedRelCount(long selectedRelCount) {
            this.selectedRelCount = selectedRelCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.remainingRels = null;
            this.remainingRelCount = 0L;
            this.selectedRels = null;
            this.selectedRelCount = 0L;
            return this;
        }

        public EdgeSplitter.SplitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSplitResult(null, this.remainingRels, this.remainingRelCount, this.selectedRels, this.selectedRelCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("remainingRels");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("remainingRelCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("selectedRels");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("selectedRelCount");
            }
            return "Cannot build SplitResult, some of required attributes are not set " + attributes;
        }
    }
}

