/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.function.Function;
import org.neo4j.gds.collections.ha.HugeLongArray;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.ReadOnlyHugeLongArray;
import org.neo4j.gds.ml.splitting.TrainingExamplesSplit;

public class FractionSplitter {
    public static MemoryEstimation estimate(double trainFraction) {
        return MemoryEstimations.builder((String)FractionSplitter.class.getSimpleName()).perNode("train", n -> HugeLongArray.memoryEstimation((long)FractionSplitter.trainSize(n, trainFraction))).perNode("test", n -> HugeLongArray.memoryEstimation((long)(n - FractionSplitter.trainSize(n, trainFraction)))).build();
    }

    private static long trainSize(long nodeCount, double trainFraction) {
        return (long)((double)nodeCount * trainFraction);
    }

    public TrainingExamplesSplit split(ReadOnlyHugeLongArray ids, double trainFraction) {
        long trainSize = FractionSplitter.trainSize(ids.size(), trainFraction);
        long testSize = ids.size() - trainSize;
        ReadOnlyHugeLongArray train = this.initHLA(trainSize, arg_0 -> ((ReadOnlyHugeLongArray)ids).get(arg_0));
        ReadOnlyHugeLongArray test = this.initHLA(testSize, i -> ids.get(i + trainSize));
        return TrainingExamplesSplit.of(train, test);
    }

    private ReadOnlyHugeLongArray initHLA(long size, Function<Long, Long> transform) {
        HugeLongArray array = HugeLongArray.newArray((long)size);
        array.setAll(transform::apply);
        return ReadOnlyHugeLongArray.of((HugeLongArray)array);
    }
}

