/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodeClassification;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.collections.ha.HugeObjectArray;
import org.neo4j.gds.ml.nodeClassification.NodeClassificationPredict;

@Generated(from="NodeClassificationPredict.NodeClassificationResult", generator="Immutables")
public final class ImmutableNodeClassificationResult
implements NodeClassificationPredict.NodeClassificationResult {
    private final HugeIntArray predictedClasses;
    private final HugeObjectArray<double[]> predictedProbabilities;

    private ImmutableNodeClassificationResult(HugeIntArray predictedClasses, Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
        this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
        this.predictedProbabilities = predictedProbabilities.orElse(null);
    }

    private ImmutableNodeClassificationResult(HugeIntArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
        this.predictedProbabilities = predictedProbabilities;
    }

    private ImmutableNodeClassificationResult(ImmutableNodeClassificationResult original, HugeIntArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        this.predictedClasses = predictedClasses;
        this.predictedProbabilities = predictedProbabilities;
    }

    @Override
    public HugeIntArray predictedClasses() {
        return this.predictedClasses;
    }

    @Override
    public Optional<HugeObjectArray<double[]>> predictedProbabilities() {
        return Optional.ofNullable(this.predictedProbabilities);
    }

    public final ImmutableNodeClassificationResult withPredictedClasses(HugeIntArray value) {
        if (this.predictedClasses == value) {
            return this;
        }
        HugeIntArray newValue = Objects.requireNonNull(value, "predictedClasses");
        return new ImmutableNodeClassificationResult(this, newValue, this.predictedProbabilities);
    }

    public final ImmutableNodeClassificationResult withPredictedProbabilities(HugeObjectArray<double[]> value) {
        HugeObjectArray<double[]> newValue = value;
        if (this.predictedProbabilities == newValue) {
            return this;
        }
        return new ImmutableNodeClassificationResult(this, this.predictedClasses, newValue);
    }

    public final ImmutableNodeClassificationResult withPredictedProbabilities(Optional<? extends HugeObjectArray<double[]>> optional) {
        HugeObjectArray value = optional.orElse(null);
        if (this.predictedProbabilities == value) {
            return this;
        }
        return new ImmutableNodeClassificationResult(this, this.predictedClasses, (HugeObjectArray<double[]>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationResult && this.equalTo(0, (ImmutableNodeClassificationResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeClassificationResult another) {
        return this.predictedClasses.equals(another.predictedClasses) && Objects.equals(this.predictedProbabilities, another.predictedProbabilities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.predictedClasses.hashCode();
        h += (h << 5) + Objects.hashCode(this.predictedProbabilities);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeClassificationResult{");
        builder.append("predictedClasses=").append(this.predictedClasses);
        if (this.predictedProbabilities != null) {
            builder.append(", ");
            builder.append("predictedProbabilities=").append(this.predictedProbabilities);
        }
        return builder.append("}").toString();
    }

    public static NodeClassificationPredict.NodeClassificationResult of(HugeIntArray predictedClasses, Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
        return new ImmutableNodeClassificationResult(predictedClasses, predictedProbabilities);
    }

    public static NodeClassificationPredict.NodeClassificationResult of(HugeIntArray predictedClasses, HugeObjectArray<double[]> predictedProbabilities) {
        return new ImmutableNodeClassificationResult(predictedClasses, predictedProbabilities);
    }

    public static NodeClassificationPredict.NodeClassificationResult copyOf(NodeClassificationPredict.NodeClassificationResult instance) {
        if (instance instanceof ImmutableNodeClassificationResult) {
            return (ImmutableNodeClassificationResult)instance;
        }
        return ImmutableNodeClassificationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeClassificationPredict.NodeClassificationResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PREDICTED_CLASSES = 1L;
        private long initBits = 1L;
        private HugeIntArray predictedClasses;
        private HugeObjectArray<double[]> predictedProbabilities;

        private Builder() {
        }

        public final Builder from(NodeClassificationPredict.NodeClassificationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.predictedClasses(instance.predictedClasses());
            Optional<HugeObjectArray<double[]>> predictedProbabilitiesOptional = instance.predictedProbabilities();
            if (predictedProbabilitiesOptional.isPresent()) {
                this.predictedProbabilities(predictedProbabilitiesOptional);
            }
            return this;
        }

        public final Builder predictedClasses(HugeIntArray predictedClasses) {
            this.predictedClasses = Objects.requireNonNull(predictedClasses, "predictedClasses");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder predictedProbabilities(HugeObjectArray<double[]> predictedProbabilities) {
            this.predictedProbabilities = predictedProbabilities;
            return this;
        }

        public final Builder predictedProbabilities(Optional<? extends HugeObjectArray<double[]>> predictedProbabilities) {
            this.predictedProbabilities = predictedProbabilities.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.predictedClasses = null;
            this.predictedProbabilities = null;
            return this;
        }

        public NodeClassificationPredict.NodeClassificationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationResult(null, this.predictedClasses, this.predictedProbabilities);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predictedClasses");
            }
            return "Cannot build NodeClassificationResult, some of required attributes are not set " + attributes;
        }
    }
}

