/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.negativeSampling;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.ml.negativeSampling.RandomNegativeSampler;
import org.neo4j.gds.ml.negativeSampling.UserInputNegativeSampler;

public interface NegativeSampler {
    public static final double NEGATIVE = 0.0;

    public static NegativeSampler of(GraphStore graphStore, Graph graph, Collection<NodeLabel> sourceAndTargetNodeLabels, Optional<String> negativeRelationshipType, double negativeSamplingRatio, long testPositiveCount, long trainPositiveCount, IdMap validSourceNodes, IdMap validTargetNodes, Collection<NodeLabel> sourceLabels, Collection<NodeLabel> targetLabels, Optional<Long> randomSeed) {
        if (negativeRelationshipType.isPresent()) {
            Graph negativeExampleGraph = graphStore.getGraph(sourceAndTargetNodeLabels, List.of(RelationshipType.of((String)negativeRelationshipType.orElseThrow())), Optional.empty());
            double testTrainFraction = (double)testPositiveCount / (double)(testPositiveCount + trainPositiveCount);
            return new UserInputNegativeSampler(negativeExampleGraph, testTrainFraction, randomSeed, sourceLabels, targetLabels);
        }
        return new RandomNegativeSampler(graph, (long)((double)testPositiveCount * negativeSamplingRatio), (long)((double)trainPositiveCount * negativeSamplingRatio), validSourceNodes, validTargetNodes, randomSeed);
    }

    public void produceNegativeSamples(RelationshipsBuilder var1, RelationshipsBuilder var2);
}

