/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import java.util.Optional;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.ml.decisiontree.DecisionTreeTrainerConfig;

@Configuration
public interface RandomForestTrainerConfig
extends DecisionTreeTrainerConfig {
    @Configuration.DoubleRange(min=0.0, max=1.0, minInclusive=false)
    public Optional<Double> maxFeaturesRatio();

    @Configuration.Ignore
    default public double maxFeaturesRatio(int featureDimension) {
        return this.maxFeaturesRatio().orElse(1.0 / Math.sqrt(featureDimension));
    }

    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double numberOfSamplesRatio() {
        return 1.0;
    }

    @Configuration.IntegerRange(min=1)
    default public int numberOfDecisionTrees() {
        return 100;
    }
}

