/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import java.util.List;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.ml.decisiontree.DecisionTreePredictor;
import org.neo4j.gds.ml.models.Regressor;
import org.neo4j.gds.ml.models.randomforest.ImmutableRandomForestRegressorData;
import org.neo4j.gds.ml.models.randomforest.RandomForestRegressorData;

public class RandomForestRegressor
implements Regressor {
    private final RandomForestRegressorData data;

    public RandomForestRegressor(List<DecisionTreePredictor<Double>> decisionTrees, int featureDimension) {
        this(ImmutableRandomForestRegressorData.of(featureDimension, decisionTrees));
    }

    public RandomForestRegressor(RandomForestRegressorData data) {
        this.data = data;
    }

    public static MemoryRange runtimeOverheadMemoryEstimation() {
        return MemoryRange.of((long)MemoryUsage.sizeOfInstance(RandomForestRegressor.class));
    }

    @Override
    public Regressor.RegressorData data() {
        return this.data;
    }

    @Override
    public double predict(double[] features) {
        int numberOfDecisionTrees = this.data.decisionTrees().size();
        double sum = 0.0;
        for (int i = 0; i < numberOfDecisionTrees; ++i) {
            sum += this.data.decisionTrees().get(i).predict(features).doubleValue();
        }
        return sum / (double)numberOfDecisionTrees;
    }
}

