/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.decisiontree.ClassifierImpurityCriterionType;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifierTrainerConfig;

public final class RandomForestClassifierTrainerConfigImpl
implements RandomForestClassifierTrainerConfig {
    private ClassifierImpurityCriterionType criterion;
    private Optional<Double> maxFeaturesRatio;
    private double numberOfSamplesRatio;
    private int numberOfDecisionTrees;
    private int maxDepth;
    private int minSplitSize;
    private int minLeafSize;

    public RandomForestClassifierTrainerConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.criterion = (ClassifierImpurityCriterionType)((Object)CypherMapAccess.failOnNull((String)"criterion", (Object)((Object)ClassifierImpurityCriterionType.parse(config.getChecked("criterion", (Object)RandomForestClassifierTrainerConfig.super.criterion(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxFeaturesRatio = (Optional)CypherMapAccess.failOnNull((String)"maxFeaturesRatio", (Object)config.getOptional("maxFeaturesRatio", Double.class));
            this.maxFeaturesRatio.ifPresent(maxFeaturesRatio -> CypherMapAccess.validateDoubleRange((String)"maxFeaturesRatio", (double)maxFeaturesRatio, (double)0.0, (double)1.0, (boolean)false, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.numberOfSamplesRatio = config.getDouble("numberOfSamplesRatio", RandomForestClassifierTrainerConfig.super.numberOfSamplesRatio());
            CypherMapAccess.validateDoubleRange((String)"numberOfSamplesRatio", (double)this.numberOfSamplesRatio, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.numberOfDecisionTrees = config.getInt("numberOfDecisionTrees", RandomForestClassifierTrainerConfig.super.numberOfDecisionTrees());
            CypherMapAccess.validateIntegerRange((String)"numberOfDecisionTrees", (int)this.numberOfDecisionTrees, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxDepth = config.getInt("maxDepth", RandomForestClassifierTrainerConfig.super.maxDepth());
            CypherMapAccess.validateIntegerRange((String)"maxDepth", (int)this.maxDepth, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minSplitSize = config.getInt("minSplitSize", RandomForestClassifierTrainerConfig.super.minSplitSize());
            CypherMapAccess.validateIntegerRange((String)"minSplitSize", (int)this.minSplitSize, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minLeafSize = config.getInt("minLeafSize", RandomForestClassifierTrainerConfig.super.minLeafSize());
            CypherMapAccess.validateIntegerRange((String)"minLeafSize", (int)this.minLeafSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateMinSizes();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public ClassifierImpurityCriterionType criterion() {
        return this.criterion;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("criterion", "maxFeaturesRatio", "numberOfSamplesRatio", "numberOfDecisionTrees", "maxDepth", "minSplitSize", "minLeafSize");
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("criterion", ClassifierImpurityCriterionType.toString(this.criterion()));
        this.maxFeaturesRatio().ifPresent(maxFeaturesRatio -> map.put("maxFeaturesRatio", maxFeaturesRatio));
        map.put("numberOfSamplesRatio", this.numberOfSamplesRatio());
        map.put("numberOfDecisionTrees", this.numberOfDecisionTrees());
        map.put("maxDepth", this.maxDepth());
        map.put("minSplitSize", this.minSplitSize());
        map.put("minLeafSize", this.minLeafSize());
        return map;
    }

    @Override
    public Optional<Double> maxFeaturesRatio() {
        return this.maxFeaturesRatio;
    }

    @Override
    public double numberOfSamplesRatio() {
        return this.numberOfSamplesRatio;
    }

    @Override
    public int numberOfDecisionTrees() {
        return this.numberOfDecisionTrees;
    }

    @Override
    public int maxDepth() {
        return this.maxDepth;
    }

    @Override
    public int minSplitSize() {
        return this.minSplitSize;
    }

    @Override
    public int minLeafSize() {
        return this.minLeafSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(RandomForestClassifierTrainerConfig baseConfig) {
            Builder builder = new Builder();
            builder.criterion((Object)baseConfig.criterion());
            builder.maxFeaturesRatio(baseConfig.maxFeaturesRatio());
            builder.numberOfSamplesRatio(baseConfig.numberOfSamplesRatio());
            builder.numberOfDecisionTrees(baseConfig.numberOfDecisionTrees());
            builder.maxDepth(baseConfig.maxDepth());
            builder.minSplitSize(baseConfig.minSplitSize());
            builder.minLeafSize(baseConfig.minLeafSize());
            return builder;
        }

        public Builder criterion(Object criterion) {
            this.config.put("criterion", criterion);
            return this;
        }

        public Builder maxFeaturesRatio(Double maxFeaturesRatio) {
            this.config.put("maxFeaturesRatio", maxFeaturesRatio);
            return this;
        }

        public Builder maxFeaturesRatio(Optional<Double> maxFeaturesRatio) {
            maxFeaturesRatio.ifPresent(actualmaxFeaturesRatio -> this.config.put("maxFeaturesRatio", actualmaxFeaturesRatio));
            return this;
        }

        public Builder numberOfSamplesRatio(double numberOfSamplesRatio) {
            this.config.put("numberOfSamplesRatio", numberOfSamplesRatio);
            return this;
        }

        public Builder numberOfDecisionTrees(int numberOfDecisionTrees) {
            this.config.put("numberOfDecisionTrees", numberOfDecisionTrees);
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.config.put("maxDepth", maxDepth);
            return this;
        }

        public Builder minSplitSize(int minSplitSize) {
            this.config.put("minSplitSize", minSplitSize);
            return this;
        }

        public Builder minLeafSize(int minLeafSize) {
            this.config.put("minLeafSize", minLeafSize);
            return this;
        }

        public RandomForestClassifierTrainerConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new RandomForestClassifierTrainerConfigImpl((CypherMapAccess)config);
        }
    }
}

