/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import com.carrotsearch.hppc.ObjectArrayList;
import java.io.Serializable;
import java.util.List;
import java.util.function.LongUnaryOperator;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.decisiontree.DecisionTreePredictor;
import org.neo4j.gds.ml.decisiontree.DecisionTreeTrainer;
import org.neo4j.gds.ml.decisiontree.TreeNode;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.models.randomforest.ImmutableRandomForestClassifierData;
import org.neo4j.gds.ml.models.randomforest.RandomForestTrainerConfig;

@ValueClass
public interface RandomForestClassifierData
extends Classifier.ClassifierData,
Serializable {
    public List<DecisionTreePredictor<Integer>> decisionTrees();

    @Override
    @Value.Derived
    default public TrainingMethod trainerMethod() {
        return TrainingMethod.RandomForestClassification;
    }

    public static MemoryEstimation memoryEstimation(LongUnaryOperator numberOfTrainingExamples, RandomForestTrainerConfig config) {
        return MemoryEstimations.builder((String)"Random forest model data").rangePerNode("Decision trees", nodeCount -> MemoryRange.of((long)MemoryUsage.sizeOfInstance(ObjectArrayList.class)).add(DecisionTreeTrainer.estimateTree(config, numberOfTrainingExamples.applyAsLong(nodeCount), TreeNode.leafMemoryEstimation(Integer.class)).times((long)config.numberOfDecisionTrees()))).build();
    }

    public static ImmutableRandomForestClassifierData.Builder builder() {
        return ImmutableRandomForestClassifierData.builder();
    }
}

