/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.decisiontree.DecisionTreePredictor;
import org.neo4j.gds.ml.models.BaseModelData;
import org.neo4j.gds.ml.models.Regressor;
import org.neo4j.gds.ml.models.randomforest.RandomForestRegressorData;

@Generated(from="RandomForestRegressorData", generator="Immutables")
public final class ImmutableRandomForestRegressorData
implements RandomForestRegressorData {
    private final int featureDimension;
    private final List<DecisionTreePredictor<Double>> decisionTrees;
    private final transient TrainingMethod trainerMethod;

    private ImmutableRandomForestRegressorData(int featureDimension, Iterable<? extends DecisionTreePredictor<Double>> decisionTrees) {
        this.featureDimension = featureDimension;
        this.decisionTrees = ImmutableRandomForestRegressorData.createUnmodifiableList(false, ImmutableRandomForestRegressorData.createSafeList(decisionTrees, true, false));
        this.trainerMethod = Objects.requireNonNull(RandomForestRegressorData.super.trainerMethod(), "trainerMethod");
    }

    private ImmutableRandomForestRegressorData(ImmutableRandomForestRegressorData original, int featureDimension, List<DecisionTreePredictor<Double>> decisionTrees) {
        this.featureDimension = featureDimension;
        this.decisionTrees = decisionTrees;
        this.trainerMethod = Objects.requireNonNull(RandomForestRegressorData.super.trainerMethod(), "trainerMethod");
    }

    @Override
    public int featureDimension() {
        return this.featureDimension;
    }

    @Override
    public List<DecisionTreePredictor<Double>> decisionTrees() {
        return this.decisionTrees;
    }

    @Override
    public TrainingMethod trainerMethod() {
        return this.trainerMethod;
    }

    public final ImmutableRandomForestRegressorData withFeatureDimension(int value) {
        if (this.featureDimension == value) {
            return this;
        }
        return new ImmutableRandomForestRegressorData(this, value, this.decisionTrees);
    }

    @SafeVarargs
    public final ImmutableRandomForestRegressorData withDecisionTrees(DecisionTreePredictor<Double> ... elements) {
        List<DecisionTreePredictor<Double>> newValue = ImmutableRandomForestRegressorData.createUnmodifiableList(false, ImmutableRandomForestRegressorData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRandomForestRegressorData(this, this.featureDimension, newValue);
    }

    public final ImmutableRandomForestRegressorData withDecisionTrees(Iterable<? extends DecisionTreePredictor<Double>> elements) {
        if (this.decisionTrees == elements) {
            return this;
        }
        List<DecisionTreePredictor<Double>> newValue = ImmutableRandomForestRegressorData.createUnmodifiableList(false, ImmutableRandomForestRegressorData.createSafeList(elements, true, false));
        return new ImmutableRandomForestRegressorData(this, this.featureDimension, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomForestRegressorData && this.equalTo(0, (ImmutableRandomForestRegressorData)another);
    }

    private boolean equalTo(int synthetic, ImmutableRandomForestRegressorData another) {
        return this.featureDimension == another.featureDimension && this.decisionTrees.equals(another.decisionTrees) && this.trainerMethod.equals((Object)another.trainerMethod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.featureDimension;
        h += (h << 5) + this.decisionTrees.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        return h;
    }

    public String toString() {
        return "RandomForestRegressorData{featureDimension=" + this.featureDimension + ", decisionTrees=" + this.decisionTrees + ", trainerMethod=" + this.trainerMethod + "}";
    }

    public static RandomForestRegressorData of(int featureDimension, List<DecisionTreePredictor<Double>> decisionTrees) {
        return ImmutableRandomForestRegressorData.of(featureDimension, decisionTrees);
    }

    public static RandomForestRegressorData of(int featureDimension, Iterable<? extends DecisionTreePredictor<Double>> decisionTrees) {
        return new ImmutableRandomForestRegressorData(featureDimension, decisionTrees);
    }

    public static RandomForestRegressorData copyOf(RandomForestRegressorData instance) {
        if (instance instanceof ImmutableRandomForestRegressorData) {
            return (ImmutableRandomForestRegressorData)instance;
        }
        return ImmutableRandomForestRegressorData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RandomForestRegressorData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FEATURE_DIMENSION = 1L;
        private long initBits = 1L;
        private int featureDimension;
        private List<DecisionTreePredictor<Double>> decisionTrees = null;

        private Builder() {
        }

        public final Builder from(RandomForestRegressorData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseModelData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Regressor.RegressorData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseModelData instance;
            long bits = 0L;
            if (object instanceof RandomForestRegressorData) {
                instance = (RandomForestRegressorData)object;
                this.addAllDecisionTrees(instance.decisionTrees());
                if ((bits & 1L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseModelData) {
                instance = (BaseModelData)object;
                if ((bits & 1L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 1L;
                }
            }
            if (object instanceof Regressor.RegressorData) {
                instance = (Regressor.RegressorData)object;
                if ((bits & 1L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 1L;
                }
            }
        }

        public final Builder featureDimension(int featureDimension) {
            this.featureDimension = featureDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addDecisionTree(DecisionTreePredictor<Double> element) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Double>>();
            }
            this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            return this;
        }

        @SafeVarargs
        public final Builder addDecisionTrees(DecisionTreePredictor<Double> ... elements) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Double>>();
            }
            for (DecisionTreePredictor<Double> element : elements) {
                this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            }
            return this;
        }

        public final Builder decisionTrees(Iterable<? extends DecisionTreePredictor<Double>> elements) {
            this.decisionTrees = new ArrayList<DecisionTreePredictor<Double>>();
            return this.addAllDecisionTrees(elements);
        }

        public final Builder addAllDecisionTrees(Iterable<? extends DecisionTreePredictor<Double>> elements) {
            Objects.requireNonNull(elements, "decisionTrees element");
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Double>>();
            }
            for (DecisionTreePredictor<Double> decisionTreePredictor : elements) {
                this.decisionTrees.add(Objects.requireNonNull(decisionTreePredictor, "decisionTrees element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.featureDimension = 0;
            if (this.decisionTrees != null) {
                this.decisionTrees.clear();
            }
            return this;
        }

        public RandomForestRegressorData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRandomForestRegressorData(null, this.featureDimension, this.decisionTrees == null ? Collections.emptyList() : ImmutableRandomForestRegressorData.createUnmodifiableList(true, this.decisionTrees));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("featureDimension");
            }
            return "Cannot build RandomForestRegressorData, some of required attributes are not set " + attributes;
        }
    }
}

