/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.decisiontree.DecisionTreePredictor;
import org.neo4j.gds.ml.models.BaseModelData;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifierData;

@Generated(from="RandomForestClassifierData", generator="Immutables")
public final class ImmutableRandomForestClassifierData
implements RandomForestClassifierData {
    private final int featureDimension;
    private final int numberOfClasses;
    private final List<DecisionTreePredictor<Integer>> decisionTrees;
    private final TrainingMethod trainerMethod;

    private ImmutableRandomForestClassifierData(int featureDimension, int numberOfClasses, Iterable<? extends DecisionTreePredictor<Integer>> decisionTrees) {
        this.featureDimension = featureDimension;
        this.numberOfClasses = numberOfClasses;
        this.decisionTrees = ImmutableRandomForestClassifierData.createUnmodifiableList(false, ImmutableRandomForestClassifierData.createSafeList(decisionTrees, true, false));
        this.trainerMethod = Objects.requireNonNull(RandomForestClassifierData.super.trainerMethod(), "trainerMethod");
    }

    private ImmutableRandomForestClassifierData(ImmutableRandomForestClassifierData original, int featureDimension, int numberOfClasses, List<DecisionTreePredictor<Integer>> decisionTrees) {
        this.featureDimension = featureDimension;
        this.numberOfClasses = numberOfClasses;
        this.decisionTrees = decisionTrees;
        this.trainerMethod = Objects.requireNonNull(RandomForestClassifierData.super.trainerMethod(), "trainerMethod");
    }

    @Override
    public int featureDimension() {
        return this.featureDimension;
    }

    @Override
    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public List<DecisionTreePredictor<Integer>> decisionTrees() {
        return this.decisionTrees;
    }

    @Override
    public TrainingMethod trainerMethod() {
        return this.trainerMethod;
    }

    public final ImmutableRandomForestClassifierData withFeatureDimension(int value) {
        if (this.featureDimension == value) {
            return this;
        }
        return new ImmutableRandomForestClassifierData(this, value, this.numberOfClasses, this.decisionTrees);
    }

    public final ImmutableRandomForestClassifierData withNumberOfClasses(int value) {
        if (this.numberOfClasses == value) {
            return this;
        }
        return new ImmutableRandomForestClassifierData(this, this.featureDimension, value, this.decisionTrees);
    }

    @SafeVarargs
    public final ImmutableRandomForestClassifierData withDecisionTrees(DecisionTreePredictor<Integer> ... elements) {
        List<DecisionTreePredictor<Integer>> newValue = ImmutableRandomForestClassifierData.createUnmodifiableList(false, ImmutableRandomForestClassifierData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRandomForestClassifierData(this, this.featureDimension, this.numberOfClasses, newValue);
    }

    public final ImmutableRandomForestClassifierData withDecisionTrees(Iterable<? extends DecisionTreePredictor<Integer>> elements) {
        if (this.decisionTrees == elements) {
            return this;
        }
        List<DecisionTreePredictor<Integer>> newValue = ImmutableRandomForestClassifierData.createUnmodifiableList(false, ImmutableRandomForestClassifierData.createSafeList(elements, true, false));
        return new ImmutableRandomForestClassifierData(this, this.featureDimension, this.numberOfClasses, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomForestClassifierData && this.equalTo(0, (ImmutableRandomForestClassifierData)another);
    }

    private boolean equalTo(int synthetic, ImmutableRandomForestClassifierData another) {
        return this.featureDimension == another.featureDimension && this.numberOfClasses == another.numberOfClasses && this.decisionTrees.equals(another.decisionTrees) && this.trainerMethod.equals((Object)another.trainerMethod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.featureDimension;
        h += (h << 5) + this.numberOfClasses;
        h += (h << 5) + this.decisionTrees.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        return h;
    }

    public String toString() {
        return "RandomForestClassifierData{featureDimension=" + this.featureDimension + ", numberOfClasses=" + this.numberOfClasses + ", decisionTrees=" + this.decisionTrees + ", trainerMethod=" + this.trainerMethod + "}";
    }

    public static RandomForestClassifierData of(int featureDimension, int numberOfClasses, List<DecisionTreePredictor<Integer>> decisionTrees) {
        return ImmutableRandomForestClassifierData.of(featureDimension, numberOfClasses, decisionTrees);
    }

    public static RandomForestClassifierData of(int featureDimension, int numberOfClasses, Iterable<? extends DecisionTreePredictor<Integer>> decisionTrees) {
        return new ImmutableRandomForestClassifierData(featureDimension, numberOfClasses, decisionTrees);
    }

    public static RandomForestClassifierData copyOf(RandomForestClassifierData instance) {
        if (instance instanceof ImmutableRandomForestClassifierData) {
            return (ImmutableRandomForestClassifierData)instance;
        }
        return ImmutableRandomForestClassifierData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RandomForestClassifierData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FEATURE_DIMENSION = 1L;
        private static final long INIT_BIT_NUMBER_OF_CLASSES = 2L;
        private long initBits = 3L;
        private int featureDimension;
        private int numberOfClasses;
        private List<DecisionTreePredictor<Integer>> decisionTrees = null;

        private Builder() {
        }

        public final Builder from(RandomForestClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Classifier.ClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BaseModelData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseModelData instance;
            long bits = 0L;
            if (object instanceof RandomForestClassifierData) {
                instance = (RandomForestClassifierData)object;
                if ((bits & 1L) == 0L) {
                    this.numberOfClasses(instance.numberOfClasses());
                    bits |= 1L;
                }
                this.addAllDecisionTrees(instance.decisionTrees());
                if ((bits & 2L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 2L;
                }
            }
            if (object instanceof Classifier.ClassifierData) {
                instance = (Classifier.ClassifierData)object;
                if ((bits & 1L) == 0L) {
                    this.numberOfClasses(instance.numberOfClasses());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseModelData) {
                instance = (BaseModelData)object;
                if ((bits & 2L) == 0L) {
                    this.featureDimension(instance.featureDimension());
                    bits |= 2L;
                }
            }
        }

        public final Builder featureDimension(int featureDimension) {
            this.featureDimension = featureDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder numberOfClasses(int numberOfClasses) {
            this.numberOfClasses = numberOfClasses;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addDecisionTree(DecisionTreePredictor<Integer> element) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Integer>>();
            }
            this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            return this;
        }

        @SafeVarargs
        public final Builder addDecisionTrees(DecisionTreePredictor<Integer> ... elements) {
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Integer>>();
            }
            for (DecisionTreePredictor<Integer> element : elements) {
                this.decisionTrees.add(Objects.requireNonNull(element, "decisionTrees element"));
            }
            return this;
        }

        public final Builder decisionTrees(Iterable<? extends DecisionTreePredictor<Integer>> elements) {
            this.decisionTrees = new ArrayList<DecisionTreePredictor<Integer>>();
            return this.addAllDecisionTrees(elements);
        }

        public final Builder addAllDecisionTrees(Iterable<? extends DecisionTreePredictor<Integer>> elements) {
            Objects.requireNonNull(elements, "decisionTrees element");
            if (this.decisionTrees == null) {
                this.decisionTrees = new ArrayList<DecisionTreePredictor<Integer>>();
            }
            for (DecisionTreePredictor<Integer> decisionTreePredictor : elements) {
                this.decisionTrees.add(Objects.requireNonNull(decisionTreePredictor, "decisionTrees element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.featureDimension = 0;
            this.numberOfClasses = 0;
            if (this.decisionTrees != null) {
                this.decisionTrees.clear();
            }
            return this;
        }

        public RandomForestClassifierData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRandomForestClassifierData(null, this.featureDimension, this.numberOfClasses, this.decisionTrees == null ? Collections.emptyList() : ImmutableRandomForestClassifierData.createUnmodifiableList(true, this.decisionTrees));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("featureDimension");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("numberOfClasses");
            }
            return "Cannot build RandomForestClassifierData, some of required attributes are not set " + attributes;
        }
    }
}

