/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.randomforest;

import com.carrotsearch.hppc.BitSet;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.ReadOnlyHugeLongArray;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifierTrainer;

@Generated(from="RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset", generator="Immutables")
public final class ImmutableBootstrappedDataset
implements RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset {
    private final BitSet trainSetIndices;
    private final ReadOnlyHugeLongArray allVectorsIndices;

    private ImmutableBootstrappedDataset(BitSet trainSetIndices, ReadOnlyHugeLongArray allVectorsIndices) {
        this.trainSetIndices = Objects.requireNonNull(trainSetIndices, "trainSetIndices");
        this.allVectorsIndices = Objects.requireNonNull(allVectorsIndices, "allVectorsIndices");
    }

    private ImmutableBootstrappedDataset(ImmutableBootstrappedDataset original, BitSet trainSetIndices, ReadOnlyHugeLongArray allVectorsIndices) {
        this.trainSetIndices = trainSetIndices;
        this.allVectorsIndices = allVectorsIndices;
    }

    @Override
    public BitSet trainSetIndices() {
        return this.trainSetIndices;
    }

    @Override
    public ReadOnlyHugeLongArray allVectorsIndices() {
        return this.allVectorsIndices;
    }

    public final ImmutableBootstrappedDataset withTrainSetIndices(BitSet value) {
        if (this.trainSetIndices == value) {
            return this;
        }
        BitSet newValue = Objects.requireNonNull(value, "trainSetIndices");
        return new ImmutableBootstrappedDataset(this, newValue, this.allVectorsIndices);
    }

    public final ImmutableBootstrappedDataset withAllVectorsIndices(ReadOnlyHugeLongArray value) {
        if (this.allVectorsIndices == value) {
            return this;
        }
        ReadOnlyHugeLongArray newValue = Objects.requireNonNull(value, "allVectorsIndices");
        return new ImmutableBootstrappedDataset(this, this.trainSetIndices, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBootstrappedDataset && this.equalTo(0, (ImmutableBootstrappedDataset)another);
    }

    private boolean equalTo(int synthetic, ImmutableBootstrappedDataset another) {
        return this.trainSetIndices.equals((Object)another.trainSetIndices) && this.allVectorsIndices.equals(another.allVectorsIndices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.trainSetIndices.hashCode();
        h += (h << 5) + this.allVectorsIndices.hashCode();
        return h;
    }

    public String toString() {
        return "BootstrappedDataset{trainSetIndices=" + this.trainSetIndices + ", allVectorsIndices=" + this.allVectorsIndices + "}";
    }

    public static RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset of(BitSet trainSetIndices, ReadOnlyHugeLongArray allVectorsIndices) {
        return new ImmutableBootstrappedDataset(trainSetIndices, allVectorsIndices);
    }

    static RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset copyOf(RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset instance) {
        if (instance instanceof ImmutableBootstrappedDataset) {
            return (ImmutableBootstrappedDataset)instance;
        }
        return ImmutableBootstrappedDataset.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_TRAIN_SET_INDICES = 1L;
        private static final long INIT_BIT_ALL_VECTORS_INDICES = 2L;
        private long initBits = 3L;
        private BitSet trainSetIndices;
        private ReadOnlyHugeLongArray allVectorsIndices;

        private Builder() {
        }

        public final Builder from(ImmutableBootstrappedDataset instance) {
            return this.from((RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset)instance);
        }

        final Builder from(RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset instance) {
            Objects.requireNonNull(instance, "instance");
            this.trainSetIndices(instance.trainSetIndices());
            this.allVectorsIndices(instance.allVectorsIndices());
            return this;
        }

        public final Builder trainSetIndices(BitSet trainSetIndices) {
            this.trainSetIndices = Objects.requireNonNull(trainSetIndices, "trainSetIndices");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder allVectorsIndices(ReadOnlyHugeLongArray allVectorsIndices) {
            this.allVectorsIndices = Objects.requireNonNull(allVectorsIndices, "allVectorsIndices");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.trainSetIndices = null;
            this.allVectorsIndices = null;
            return this;
        }

        public RandomForestClassifierTrainer.TrainDecisionTreeTask.BootstrappedDataset build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBootstrappedDataset(null, this.trainSetIndices, this.allVectorsIndices);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("trainSetIndices");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("allVectorsIndices");
            }
            return "Cannot build BootstrappedDataset, some of required attributes are not set " + attributes;
        }
    }
}

