/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.mlp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.gradientdescent.GradientDescentConfig;
import org.neo4j.gds.ml.models.ClassAwareTrainerConfig;
import org.neo4j.gds.ml.models.PenaltyConfig;
import org.neo4j.gds.ml.models.mlp.MLPClassifierTrainConfigImpl;

@Configuration
public interface MLPClassifierTrainConfig
extends GradientDescentConfig,
PenaltyConfig,
ClassAwareTrainerConfig {
    public static final MLPClassifierTrainConfig DEFAULT = MLPClassifierTrainConfig.of(Map.of());

    default public List<Integer> hiddenLayerSizes() {
        return List.of(Integer.valueOf(100));
    }

    @Override
    @Configuration.ToMap
    public Map<String, Object> toMap();

    @Configuration.CollectKeys
    public Collection<String> configKeys();

    public static MLPClassifierTrainConfig of(Map<String, Object> params) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(params);
        MLPClassifierTrainConfigImpl config = new MLPClassifierTrainConfigImpl((CypherMapAccess)cypherMapWrapper);
        cypherMapWrapper.requireOnlyKeysFrom(config.configKeys());
        return config;
    }

    @Override
    @Configuration.Ignore
    default public TrainingMethod method() {
        return TrainingMethod.MLPClassification;
    }
}

