/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.mlp;

import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.ml.core.Variable;
import org.neo4j.gds.ml.core.batch.Batch;
import org.neo4j.gds.ml.core.functions.Constant;
import org.neo4j.gds.ml.core.functions.ConstantScale;
import org.neo4j.gds.ml.core.functions.CrossEntropyLoss;
import org.neo4j.gds.ml.core.functions.ElementSum;
import org.neo4j.gds.ml.core.functions.FocalLoss;
import org.neo4j.gds.ml.core.functions.L2NormSquared;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Scalar;
import org.neo4j.gds.ml.core.tensor.Tensor;
import org.neo4j.gds.ml.core.tensor.Vector;
import org.neo4j.gds.ml.gradientdescent.Objective;
import org.neo4j.gds.ml.models.Features;
import org.neo4j.gds.ml.models.mlp.MLPClassifier;
import org.neo4j.gds.ml.models.mlp.MLPClassifierData;

public class MLPClassifierObjective
implements Objective<MLPClassifierData> {
    private final MLPClassifier classifier;
    private final Features features;
    private final HugeIntArray labels;
    private final double penalty;
    private final double focusWeight;
    private final double[] classWeights;

    public MLPClassifierObjective(MLPClassifier classifier, Features features, HugeIntArray labels, double penalty, double focusWeight, double[] classWeights) {
        this.classifier = classifier;
        this.features = features;
        this.labels = labels;
        this.penalty = penalty;
        this.focusWeight = focusWeight;
        this.classWeights = classWeights;
    }

    @Override
    public List<Weights<? extends Tensor<?>>> weights() {
        ArrayList combinedWeights = new ArrayList();
        combinedWeights.addAll(this.classifier.data().weights());
        combinedWeights.addAll(this.classifier.data().biases());
        return combinedWeights;
    }

    @Override
    public Variable<Scalar> loss(Batch batch, long trainSize) {
        CrossEntropyLoss crossEntropyLoss = this.crossEntropyLoss(batch);
        ConstantScale<Scalar> penalty = this.penaltyForBatch(batch, trainSize);
        return new ElementSum(List.of(crossEntropyLoss, penalty));
    }

    CrossEntropyLoss crossEntropyLoss(Batch batch) {
        Constant<Vector> batchLabels = this.batchLabelVector(batch);
        Constant<Matrix> batchFeatures = Objective.batchFeatureMatrix(batch, this.features);
        Variable<Matrix> predictions = this.classifier.predictionsVariable(batchFeatures);
        if (this.focusWeight == 0.0) {
            return new CrossEntropyLoss(predictions, batchLabels, this.classWeights);
        }
        return new FocalLoss(predictions, batchLabels, this.focusWeight, this.classWeights);
    }

    ConstantScale<Scalar> penaltyForBatch(Batch batch, long trainSize) {
        List L2Norms = this.classifier.data().weights().stream().map(L2NormSquared::new).collect(Collectors.toList());
        return new ConstantScale((Variable)new ElementSum(L2Norms), (double)batch.size() * this.penalty / (double)trainSize);
    }

    Constant<Vector> batchLabelVector(Batch batch) {
        Vector batchedTargets = new Vector(batch.size());
        int batchOffset = 0;
        PrimitiveIterator.OfLong batchIterator = batch.elementIds();
        while (batchIterator.hasNext()) {
            long elementId = batchIterator.nextLong();
            batchedTargets.setDataAt(batchOffset++, (double)this.labels.get(elementId));
        }
        return new Constant((Tensor)batchedTargets);
    }

    @Override
    public MLPClassifierData modelData() {
        return this.classifier.data();
    }
}

