/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.mlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Vector;
import org.neo4j.gds.ml.models.mlp.MLPClassifierData;

@Generated(from="MLPClassifierData", generator="Immutables")
public final class ImmutableMLPClassifierData
implements MLPClassifierData {
    private final List<Weights<Matrix>> weights;
    private final List<Weights<Vector>> biases;
    private final int depth;
    private final int numberOfClasses;
    private final int featureDimension;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMLPClassifierData(Iterable<? extends Weights<Matrix>> weights, Iterable<? extends Weights<Vector>> biases) {
        this.weights = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(weights, true, false));
        this.biases = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(biases, true, false));
        this.depth = this.initShim.depth();
        this.numberOfClasses = this.initShim.numberOfClasses();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private ImmutableMLPClassifierData(ImmutableMLPClassifierData original, List<Weights<Matrix>> weights, List<Weights<Vector>> biases) {
        this.weights = weights;
        this.biases = biases;
        this.depth = this.initShim.depth();
        this.numberOfClasses = this.initShim.numberOfClasses();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private int depthInitialize() {
        return MLPClassifierData.super.depth();
    }

    private int numberOfClassesInitialize() {
        return MLPClassifierData.super.numberOfClasses();
    }

    private int featureDimensionInitialize() {
        return MLPClassifierData.super.featureDimension();
    }

    @Override
    public List<Weights<Matrix>> weights() {
        return this.weights;
    }

    @Override
    public List<Weights<Vector>> biases() {
        return this.biases;
    }

    @Override
    public int depth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.depth() : this.depth;
    }

    @Override
    public int numberOfClasses() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numberOfClasses() : this.numberOfClasses;
    }

    @Override
    public int featureDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureDimension() : this.featureDimension;
    }

    @SafeVarargs
    public final ImmutableMLPClassifierData withWeights(Weights<Matrix> ... elements) {
        List<Weights<Matrix>> newValue = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMLPClassifierData(this, newValue, this.biases);
    }

    public final ImmutableMLPClassifierData withWeights(Iterable<? extends Weights<Matrix>> elements) {
        if (this.weights == elements) {
            return this;
        }
        List<? extends Weights<Matrix>> newValue = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(elements, true, false));
        return new ImmutableMLPClassifierData(this, newValue, this.biases);
    }

    @SafeVarargs
    public final ImmutableMLPClassifierData withBiases(Weights<Vector> ... elements) {
        List<Weights<Vector>> newValue = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMLPClassifierData(this, this.weights, newValue);
    }

    public final ImmutableMLPClassifierData withBiases(Iterable<? extends Weights<Vector>> elements) {
        if (this.biases == elements) {
            return this;
        }
        List<? extends Weights<Vector>> newValue = ImmutableMLPClassifierData.createUnmodifiableList(false, ImmutableMLPClassifierData.createSafeList(elements, true, false));
        return new ImmutableMLPClassifierData(this, this.weights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMLPClassifierData && this.equalTo(0, (ImmutableMLPClassifierData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMLPClassifierData another) {
        return this.weights.equals(another.weights) && this.biases.equals(another.biases) && this.depth == another.depth && this.numberOfClasses == another.numberOfClasses && this.featureDimension == another.featureDimension;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.weights.hashCode();
        h += (h << 5) + this.biases.hashCode();
        h += (h << 5) + this.depth;
        h += (h << 5) + this.numberOfClasses;
        h += (h << 5) + this.featureDimension;
        return h;
    }

    public String toString() {
        return "MLPClassifierData{weights=" + this.weights + ", biases=" + this.biases + ", depth=" + this.depth + ", numberOfClasses=" + this.numberOfClasses + ", featureDimension=" + this.featureDimension + "}";
    }

    public static MLPClassifierData of(List<Weights<Matrix>> weights, List<Weights<Vector>> biases) {
        return ImmutableMLPClassifierData.of(weights, biases);
    }

    public static MLPClassifierData of(Iterable<? extends Weights<Matrix>> weights, Iterable<? extends Weights<Vector>> biases) {
        return new ImmutableMLPClassifierData(weights, biases);
    }

    public static MLPClassifierData copyOf(MLPClassifierData instance) {
        if (instance instanceof ImmutableMLPClassifierData) {
            return (ImmutableMLPClassifierData)instance;
        }
        return ImmutableMLPClassifierData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MLPClassifierData", generator="Immutables")
    private final class InitShim {
        private byte depthBuildStage = 0;
        private int depth;
        private byte numberOfClassesBuildStage = 0;
        private int numberOfClasses;
        private byte featureDimensionBuildStage = 0;
        private int featureDimension;

        private InitShim() {
        }

        int depth() {
            if (this.depthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.depthBuildStage == 0) {
                this.depthBuildStage = (byte)-1;
                this.depth = ImmutableMLPClassifierData.this.depthInitialize();
                this.depthBuildStage = 1;
            }
            return this.depth;
        }

        int numberOfClasses() {
            if (this.numberOfClassesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numberOfClassesBuildStage == 0) {
                this.numberOfClassesBuildStage = (byte)-1;
                this.numberOfClasses = ImmutableMLPClassifierData.this.numberOfClassesInitialize();
                this.numberOfClassesBuildStage = 1;
            }
            return this.numberOfClasses;
        }

        int featureDimension() {
            if (this.featureDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureDimensionBuildStage == 0) {
                this.featureDimensionBuildStage = (byte)-1;
                this.featureDimension = ImmutableMLPClassifierData.this.featureDimensionInitialize();
                this.featureDimensionBuildStage = 1;
            }
            return this.featureDimension;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.depthBuildStage == -1) {
                attributes.add("depth");
            }
            if (this.numberOfClassesBuildStage == -1) {
                attributes.add("numberOfClasses");
            }
            if (this.featureDimensionBuildStage == -1) {
                attributes.add("featureDimension");
            }
            return "Cannot build MLPClassifierData, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MLPClassifierData", generator="Immutables")
    public static final class Builder {
        private List<Weights<Matrix>> weights = null;
        private List<Weights<Vector>> biases = null;

        private Builder() {
        }

        public final Builder from(MLPClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllWeights(instance.weights());
            this.addAllBiases(instance.biases());
            return this;
        }

        public final Builder addWeight(Weights<Matrix> element) {
            if (this.weights == null) {
                this.weights = new ArrayList<Weights<Matrix>>();
            }
            this.weights.add(Objects.requireNonNull(element, "weights element"));
            return this;
        }

        @SafeVarargs
        public final Builder addWeights(Weights<Matrix> ... elements) {
            if (this.weights == null) {
                this.weights = new ArrayList<Weights<Matrix>>();
            }
            for (Weights<Matrix> element : elements) {
                this.weights.add(Objects.requireNonNull(element, "weights element"));
            }
            return this;
        }

        public final Builder weights(Iterable<? extends Weights<Matrix>> elements) {
            this.weights = new ArrayList<Weights<Matrix>>();
            return this.addAllWeights(elements);
        }

        public final Builder addAllWeights(Iterable<? extends Weights<Matrix>> elements) {
            Objects.requireNonNull(elements, "weights element");
            if (this.weights == null) {
                this.weights = new ArrayList<Weights<Matrix>>();
            }
            for (Weights<Matrix> weights : elements) {
                this.weights.add(Objects.requireNonNull(weights, "weights element"));
            }
            return this;
        }

        public final Builder addBiase(Weights<Vector> element) {
            if (this.biases == null) {
                this.biases = new ArrayList<Weights<Vector>>();
            }
            this.biases.add(Objects.requireNonNull(element, "biases element"));
            return this;
        }

        @SafeVarargs
        public final Builder addBiases(Weights<Vector> ... elements) {
            if (this.biases == null) {
                this.biases = new ArrayList<Weights<Vector>>();
            }
            for (Weights<Vector> element : elements) {
                this.biases.add(Objects.requireNonNull(element, "biases element"));
            }
            return this;
        }

        public final Builder biases(Iterable<? extends Weights<Vector>> elements) {
            this.biases = new ArrayList<Weights<Vector>>();
            return this.addAllBiases(elements);
        }

        public final Builder addAllBiases(Iterable<? extends Weights<Vector>> elements) {
            Objects.requireNonNull(elements, "biases element");
            if (this.biases == null) {
                this.biases = new ArrayList<Weights<Vector>>();
            }
            for (Weights<Vector> weights : elements) {
                this.biases.add(Objects.requireNonNull(weights, "biases element"));
            }
            return this;
        }

        public Builder clear() {
            if (this.weights != null) {
                this.weights.clear();
            }
            if (this.biases != null) {
                this.biases.clear();
            }
            return this;
        }

        public MLPClassifierData build() {
            return new ImmutableMLPClassifierData(null, this.weights == null ? Collections.emptyList() : ImmutableMLPClassifierData.createUnmodifiableList(true, this.weights), this.biases == null ? Collections.emptyList() : ImmutableMLPClassifierData.createUnmodifiableList(true, this.biases));
        }
    }
}

