/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.logisticregression;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Vector;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.models.logisticregression.LogisticRegressionData;

@Generated(from="LogisticRegressionData", generator="Immutables")
public final class ImmutableLogisticRegressionData
implements LogisticRegressionData {
    private final int numberOfClasses;
    private final Weights<Matrix> weights;
    private final Weights<Vector> bias;
    private final TrainingMethod trainerMethod;
    private final int featureDimension;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLogisticRegressionData(int numberOfClasses, Weights<Matrix> weights, Weights<Vector> bias) {
        this.numberOfClasses = numberOfClasses;
        this.weights = Objects.requireNonNull(weights, "weights");
        this.bias = Objects.requireNonNull(bias, "bias");
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private ImmutableLogisticRegressionData(ImmutableLogisticRegressionData original, int numberOfClasses, Weights<Matrix> weights, Weights<Vector> bias) {
        this.numberOfClasses = numberOfClasses;
        this.weights = weights;
        this.bias = bias;
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private TrainingMethod trainerMethodInitialize() {
        return LogisticRegressionData.super.trainerMethod();
    }

    private int featureDimensionInitialize() {
        return LogisticRegressionData.super.featureDimension();
    }

    @Override
    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public Weights<Matrix> weights() {
        return this.weights;
    }

    @Override
    public Weights<Vector> bias() {
        return this.bias;
    }

    @Override
    public TrainingMethod trainerMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainerMethod() : this.trainerMethod;
    }

    @Override
    public int featureDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureDimension() : this.featureDimension;
    }

    public final ImmutableLogisticRegressionData withNumberOfClasses(int value) {
        if (this.numberOfClasses == value) {
            return this;
        }
        return new ImmutableLogisticRegressionData(this, value, this.weights, this.bias);
    }

    public final ImmutableLogisticRegressionData withWeights(Weights<Matrix> value) {
        if (this.weights == value) {
            return this;
        }
        Weights<Matrix> newValue = Objects.requireNonNull(value, "weights");
        return new ImmutableLogisticRegressionData(this, this.numberOfClasses, newValue, this.bias);
    }

    public final ImmutableLogisticRegressionData withBias(Weights<Vector> value) {
        if (this.bias == value) {
            return this;
        }
        Weights<Vector> newValue = Objects.requireNonNull(value, "bias");
        return new ImmutableLogisticRegressionData(this, this.numberOfClasses, this.weights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogisticRegressionData && this.equalTo(0, (ImmutableLogisticRegressionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableLogisticRegressionData another) {
        return this.numberOfClasses == another.numberOfClasses && this.weights.equals(another.weights) && this.bias.equals(another.bias) && this.trainerMethod.equals((Object)another.trainerMethod) && this.featureDimension == another.featureDimension;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.numberOfClasses;
        h += (h << 5) + this.weights.hashCode();
        h += (h << 5) + this.bias.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        h += (h << 5) + this.featureDimension;
        return h;
    }

    public String toString() {
        return "LogisticRegressionData{numberOfClasses=" + this.numberOfClasses + ", weights=" + this.weights + ", bias=" + this.bias + ", trainerMethod=" + this.trainerMethod + ", featureDimension=" + this.featureDimension + "}";
    }

    public static LogisticRegressionData of(int numberOfClasses, Weights<Matrix> weights, Weights<Vector> bias) {
        return new ImmutableLogisticRegressionData(numberOfClasses, weights, bias);
    }

    public static LogisticRegressionData copyOf(LogisticRegressionData instance) {
        if (instance instanceof ImmutableLogisticRegressionData) {
            return (ImmutableLogisticRegressionData)instance;
        }
        return ImmutableLogisticRegressionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LogisticRegressionData", generator="Immutables")
    private final class InitShim {
        private byte trainerMethodBuildStage = 0;
        private TrainingMethod trainerMethod;
        private byte featureDimensionBuildStage = 0;
        private int featureDimension;

        private InitShim() {
        }

        TrainingMethod trainerMethod() {
            if (this.trainerMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainerMethodBuildStage == 0) {
                this.trainerMethodBuildStage = (byte)-1;
                this.trainerMethod = Objects.requireNonNull(ImmutableLogisticRegressionData.this.trainerMethodInitialize(), "trainerMethod");
                this.trainerMethodBuildStage = 1;
            }
            return this.trainerMethod;
        }

        int featureDimension() {
            if (this.featureDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureDimensionBuildStage == 0) {
                this.featureDimensionBuildStage = (byte)-1;
                this.featureDimension = ImmutableLogisticRegressionData.this.featureDimensionInitialize();
                this.featureDimensionBuildStage = 1;
            }
            return this.featureDimension;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.trainerMethodBuildStage == -1) {
                attributes.add("trainerMethod");
            }
            if (this.featureDimensionBuildStage == -1) {
                attributes.add("featureDimension");
            }
            return "Cannot build LogisticRegressionData, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="LogisticRegressionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NUMBER_OF_CLASSES = 1L;
        private static final long INIT_BIT_WEIGHTS = 2L;
        private static final long INIT_BIT_BIAS = 4L;
        private long initBits = 7L;
        private int numberOfClasses;
        private Weights<Matrix> weights;
        private Weights<Vector> bias;

        private Builder() {
        }

        public final Builder from(Classifier.ClassifierData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(LogisticRegressionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Classifier.ClassifierData instance;
            long bits = 0L;
            if (object instanceof Classifier.ClassifierData) {
                instance = (Classifier.ClassifierData)object;
                if ((bits & 1L) == 0L) {
                    this.numberOfClasses(instance.numberOfClasses());
                    bits |= 1L;
                }
            }
            if (object instanceof LogisticRegressionData) {
                instance = (LogisticRegressionData)object;
                if ((bits & 1L) == 0L) {
                    this.numberOfClasses(instance.numberOfClasses());
                    bits |= 1L;
                }
                this.weights(instance.weights());
                this.bias(instance.bias());
            }
        }

        public final Builder numberOfClasses(int numberOfClasses) {
            this.numberOfClasses = numberOfClasses;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder weights(Weights<Matrix> weights) {
            this.weights = Objects.requireNonNull(weights, "weights");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bias(Weights<Vector> bias) {
            this.bias = Objects.requireNonNull(bias, "bias");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.numberOfClasses = 0;
            this.weights = null;
            this.bias = null;
            return this;
        }

        public LogisticRegressionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogisticRegressionData(null, this.numberOfClasses, this.weights, this.bias);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("numberOfClasses");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("weights");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bias");
            }
            return "Cannot build LogisticRegressionData, some of required attributes are not set " + attributes;
        }
    }
}

