/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.linearregression;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Scalar;
import org.neo4j.gds.ml.models.Regressor;
import org.neo4j.gds.ml.models.linearregression.ImmutableLinearRegressionData;

@ValueClass
public interface LinearRegressionData
extends Regressor.RegressorData {
    public Weights<Matrix> weights();

    public Weights<Scalar> bias();

    @Override
    @Value.Derived
    default public TrainingMethod trainerMethod() {
        return TrainingMethod.LinearRegression;
    }

    @Override
    @Value.Derived
    default public int featureDimension() {
        return ((Matrix)this.weights().data()).cols();
    }

    public static LinearRegressionData of(int featureDimension) {
        return ImmutableLinearRegressionData.builder().weights((Weights<Matrix>)Weights.ofMatrix((int)1, (int)featureDimension)).bias((Weights<Scalar>)Weights.ofScalar((double)0.0)).build();
    }
}

