/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.linearregression;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.core.functions.Weights;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.core.tensor.Scalar;
import org.neo4j.gds.ml.models.linearregression.LinearRegressionData;

@Generated(from="LinearRegressionData", generator="Immutables")
public final class ImmutableLinearRegressionData
implements LinearRegressionData {
    private final Weights<Matrix> weights;
    private final Weights<Scalar> bias;
    private final transient TrainingMethod trainerMethod;
    private final transient int featureDimension;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLinearRegressionData(Weights<Matrix> weights, Weights<Scalar> bias) {
        this.weights = Objects.requireNonNull(weights, "weights");
        this.bias = Objects.requireNonNull(bias, "bias");
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private ImmutableLinearRegressionData(ImmutableLinearRegressionData original, Weights<Matrix> weights, Weights<Scalar> bias) {
        this.weights = weights;
        this.bias = bias;
        this.trainerMethod = this.initShim.trainerMethod();
        this.featureDimension = this.initShim.featureDimension();
        this.initShim = null;
    }

    private TrainingMethod trainerMethodInitialize() {
        return LinearRegressionData.super.trainerMethod();
    }

    private int featureDimensionInitialize() {
        return LinearRegressionData.super.featureDimension();
    }

    @Override
    public Weights<Matrix> weights() {
        return this.weights;
    }

    @Override
    public Weights<Scalar> bias() {
        return this.bias;
    }

    @Override
    public TrainingMethod trainerMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainerMethod() : this.trainerMethod;
    }

    @Override
    public int featureDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureDimension() : this.featureDimension;
    }

    public final ImmutableLinearRegressionData withWeights(Weights<Matrix> value) {
        if (this.weights == value) {
            return this;
        }
        Weights<Matrix> newValue = Objects.requireNonNull(value, "weights");
        return new ImmutableLinearRegressionData(this, newValue, this.bias);
    }

    public final ImmutableLinearRegressionData withBias(Weights<Scalar> value) {
        if (this.bias == value) {
            return this;
        }
        Weights<Scalar> newValue = Objects.requireNonNull(value, "bias");
        return new ImmutableLinearRegressionData(this, this.weights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinearRegressionData && this.equalTo(0, (ImmutableLinearRegressionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableLinearRegressionData another) {
        return this.weights.equals(another.weights) && this.bias.equals(another.bias) && this.trainerMethod.equals((Object)another.trainerMethod) && this.featureDimension == another.featureDimension;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.weights.hashCode();
        h += (h << 5) + this.bias.hashCode();
        h += (h << 5) + this.trainerMethod.hashCode();
        h += (h << 5) + this.featureDimension;
        return h;
    }

    public String toString() {
        return "LinearRegressionData{weights=" + this.weights + ", bias=" + this.bias + ", trainerMethod=" + this.trainerMethod + ", featureDimension=" + this.featureDimension + "}";
    }

    public static LinearRegressionData of(Weights<Matrix> weights, Weights<Scalar> bias) {
        return new ImmutableLinearRegressionData(weights, bias);
    }

    public static LinearRegressionData copyOf(LinearRegressionData instance) {
        if (instance instanceof ImmutableLinearRegressionData) {
            return (ImmutableLinearRegressionData)instance;
        }
        return ImmutableLinearRegressionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinearRegressionData", generator="Immutables")
    private final class InitShim {
        private byte trainerMethodBuildStage = 0;
        private TrainingMethod trainerMethod;
        private byte featureDimensionBuildStage = 0;
        private int featureDimension;

        private InitShim() {
        }

        TrainingMethod trainerMethod() {
            if (this.trainerMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainerMethodBuildStage == 0) {
                this.trainerMethodBuildStage = (byte)-1;
                this.trainerMethod = Objects.requireNonNull(ImmutableLinearRegressionData.this.trainerMethodInitialize(), "trainerMethod");
                this.trainerMethodBuildStage = 1;
            }
            return this.trainerMethod;
        }

        int featureDimension() {
            if (this.featureDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureDimensionBuildStage == 0) {
                this.featureDimensionBuildStage = (byte)-1;
                this.featureDimension = ImmutableLinearRegressionData.this.featureDimensionInitialize();
                this.featureDimensionBuildStage = 1;
            }
            return this.featureDimension;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.trainerMethodBuildStage == -1) {
                attributes.add("trainerMethod");
            }
            if (this.featureDimensionBuildStage == -1) {
                attributes.add("featureDimension");
            }
            return "Cannot build LinearRegressionData, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="LinearRegressionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WEIGHTS = 1L;
        private static final long INIT_BIT_BIAS = 2L;
        private long initBits = 3L;
        private Weights<Matrix> weights;
        private Weights<Scalar> bias;

        private Builder() {
        }

        public final Builder from(LinearRegressionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.weights(instance.weights());
            this.bias(instance.bias());
            return this;
        }

        public final Builder weights(Weights<Matrix> weights) {
            this.weights = Objects.requireNonNull(weights, "weights");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder bias(Weights<Scalar> bias) {
            this.bias = Objects.requireNonNull(bias, "bias");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.weights = null;
            this.bias = null;
            return this;
        }

        public LinearRegressionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinearRegressionData(null, this.weights, this.bias);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("weights");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bias");
            }
            return "Cannot build LinearRegressionData, some of required attributes are not set " + attributes;
        }
    }
}

