/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl.hyperparameter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.automl.hyperparameter.NumericalRangeParameter;

@Generated(from="NumericalRangeParameter", generator="Immutables")
public final class ImmutableNumericalRangeParameter<T extends Number>
implements NumericalRangeParameter<T> {
    private final T min;
    private final T max;
    private final transient Map<String, Object> toMap;

    private ImmutableNumericalRangeParameter(T min, T max) {
        this.min = (Number)Objects.requireNonNull(min, "min");
        this.max = (Number)Objects.requireNonNull(max, "max");
        this.toMap = Objects.requireNonNull(NumericalRangeParameter.super.toMap(), "toMap");
    }

    private ImmutableNumericalRangeParameter(ImmutableNumericalRangeParameter<T> original, T min, T max) {
        this.min = min;
        this.max = max;
        this.toMap = Objects.requireNonNull(NumericalRangeParameter.super.toMap(), "toMap");
    }

    @Override
    public T min() {
        return this.min;
    }

    @Override
    public T max() {
        return this.max;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableNumericalRangeParameter<T> withMin(T value) {
        if (this.min == value) {
            return this;
        }
        Number newValue = (Number)Objects.requireNonNull(value, "min");
        return new ImmutableNumericalRangeParameter<Number>(this, newValue, (Number)this.max);
    }

    public final ImmutableNumericalRangeParameter<T> withMax(T value) {
        if (this.max == value) {
            return this;
        }
        Number newValue = (Number)Objects.requireNonNull(value, "max");
        return new ImmutableNumericalRangeParameter<Number>(this, (Number)this.min, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNumericalRangeParameter && this.equalTo(0, (ImmutableNumericalRangeParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableNumericalRangeParameter<?> another) {
        return this.min.equals(another.min) && this.max.equals(another.max) && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min.hashCode();
        h += (h << 5) + this.max.hashCode();
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "NumericalRangeParameter{min=" + this.min + ", max=" + this.max + ", toMap=" + this.toMap + "}";
    }

    public static <T extends Number> NumericalRangeParameter<T> of(T min, T max) {
        return new ImmutableNumericalRangeParameter<T>(min, max);
    }

    public static <T extends Number> NumericalRangeParameter<T> copyOf(NumericalRangeParameter<T> instance) {
        if (instance instanceof ImmutableNumericalRangeParameter) {
            return (ImmutableNumericalRangeParameter)instance;
        }
        return ImmutableNumericalRangeParameter.builder().from(instance).build();
    }

    public static <T extends Number> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="NumericalRangeParameter", generator="Immutables")
    public static final class Builder<T extends Number> {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private T min;
        private T max;

        private Builder() {
        }

        public final Builder<T> from(NumericalRangeParameter<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.min(instance.min());
            this.max(instance.max());
            return this;
        }

        public final Builder<T> min(T min) {
            this.min = (Number)Objects.requireNonNull(min, "min");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> max(T max) {
            this.max = (Number)Objects.requireNonNull(max, "max");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder<T> clear() {
            this.initBits = 3L;
            this.min = null;
            this.max = null;
            return this;
        }

        public NumericalRangeParameter<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNumericalRangeParameter<T>(null, this.min, this.max);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build NumericalRangeParameter, some of required attributes are not set " + attributes;
        }
    }
}

