/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl.hyperparameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.automl.hyperparameter.ListParameter;

@Generated(from="ListParameter", generator="Immutables")
public final class ImmutableListParameter
implements ListParameter {
    private final List<Integer> value;

    private ImmutableListParameter(Iterable<Integer> value) {
        this.value = ImmutableListParameter.createUnmodifiableList(false, ImmutableListParameter.createSafeList(value, true, false));
    }

    private ImmutableListParameter(ImmutableListParameter original, List<Integer> value) {
        this.value = value;
    }

    @Override
    public List<Integer> value() {
        return this.value;
    }

    public final ImmutableListParameter withValue(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableListParameter.createUnmodifiableList(false, wrappedList);
        return new ImmutableListParameter(this, newValue);
    }

    public final ImmutableListParameter withValue(Iterable<Integer> elements) {
        if (this.value == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableListParameter.createUnmodifiableList(false, ImmutableListParameter.createSafeList(elements, true, false));
        return new ImmutableListParameter(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListParameter && this.equalTo(0, (ImmutableListParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableListParameter another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ListParameter{value=" + this.value + "}";
    }

    public static ListParameter of(List<Integer> value) {
        return ImmutableListParameter.of(value);
    }

    public static ListParameter of(Iterable<Integer> value) {
        return new ImmutableListParameter(value);
    }

    public static ListParameter copyOf(ListParameter instance) {
        if (instance instanceof ImmutableListParameter) {
            return (ImmutableListParameter)instance;
        }
        return ImmutableListParameter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ListParameter", generator="Immutables")
    public static final class Builder {
        private List<Integer> value = null;

        private Builder() {
        }

        public final Builder from(ListParameter instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllValue((Iterable)instance.value());
            return this;
        }

        public final Builder addValue(int element) {
            if (this.value == null) {
                this.value = new ArrayList<Integer>();
            }
            this.value.add(element);
            return this;
        }

        public final Builder addValue(int ... elements) {
            if (this.value == null) {
                this.value = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.value.add(element);
            }
            return this;
        }

        public final Builder value(Iterable<Integer> elements) {
            this.value = new ArrayList<Integer>();
            return this.addAllValue(elements);
        }

        public final Builder addAllValue(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "value element");
            if (this.value == null) {
                this.value = new ArrayList<Integer>();
            }
            for (Integer element : elements) {
                this.value.add(Objects.requireNonNull(element, "value element"));
            }
            return this;
        }

        public Builder clear() {
            if (this.value != null) {
                this.value.clear();
            }
            return this;
        }

        public ListParameter build() {
            return new ImmutableListParameter(null, this.value == null ? Collections.emptyList() : ImmutableListParameter.createUnmodifiableList(true, this.value));
        }
    }
}

