/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl.hyperparameter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.automl.hyperparameter.IntegerRangeParameter;

@Generated(from="IntegerRangeParameter", generator="Immutables")
public final class ImmutableIntegerRangeParameter
implements IntegerRangeParameter {
    private final Integer min;
    private final Integer max;
    private final transient Map<String, Object> toMap;

    private ImmutableIntegerRangeParameter(Integer min, Integer max) {
        this.min = Objects.requireNonNull(min, "min");
        this.max = Objects.requireNonNull(max, "max");
        this.toMap = Objects.requireNonNull(IntegerRangeParameter.super.toMap(), "toMap");
    }

    private ImmutableIntegerRangeParameter(ImmutableIntegerRangeParameter original, Integer min, Integer max) {
        this.min = min;
        this.max = max;
        this.toMap = Objects.requireNonNull(IntegerRangeParameter.super.toMap(), "toMap");
    }

    @Override
    public Integer min() {
        return this.min;
    }

    @Override
    public Integer max() {
        return this.max;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableIntegerRangeParameter withMin(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "min");
        if (this.min.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegerRangeParameter(this, newValue, this.max);
    }

    public final ImmutableIntegerRangeParameter withMax(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "max");
        if (this.max.equals(newValue)) {
            return this;
        }
        return new ImmutableIntegerRangeParameter(this, this.min, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIntegerRangeParameter && this.equalTo(0, (ImmutableIntegerRangeParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableIntegerRangeParameter another) {
        return this.min.equals(another.min) && this.max.equals(another.max) && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min.hashCode();
        h += (h << 5) + this.max.hashCode();
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "IntegerRangeParameter{min=" + this.min + ", max=" + this.max + ", toMap=" + this.toMap + "}";
    }

    public static IntegerRangeParameter of(Integer min, Integer max) {
        return new ImmutableIntegerRangeParameter(min, max);
    }

    public static IntegerRangeParameter copyOf(IntegerRangeParameter instance) {
        if (instance instanceof ImmutableIntegerRangeParameter) {
            return (ImmutableIntegerRangeParameter)instance;
        }
        return ImmutableIntegerRangeParameter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IntegerRangeParameter", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private Integer min;
        private Integer max;

        private Builder() {
        }

        public final Builder from(IntegerRangeParameter instance) {
            Objects.requireNonNull(instance, "instance");
            this.min((Integer)instance.min());
            this.max((Integer)instance.max());
            return this;
        }

        public final Builder min(Integer min) {
            this.min = Objects.requireNonNull(min, "min");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder max(Integer max) {
            this.max = Objects.requireNonNull(max, "max");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.min = null;
            this.max = null;
            return this;
        }

        public IntegerRangeParameter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIntegerRangeParameter(null, this.min, this.max);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build IntegerRangeParameter, some of required attributes are not set " + attributes;
        }
    }
}

