/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl.hyperparameter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.automl.hyperparameter.DoubleRangeParameter;

@Generated(from="DoubleRangeParameter", generator="Immutables")
public final class ImmutableDoubleRangeParameter
implements DoubleRangeParameter {
    private final Double min;
    private final Double max;
    private final boolean logScale;
    private final transient Map<String, Object> toMap;

    private ImmutableDoubleRangeParameter(Double min, Double max, boolean logScale) {
        this.min = Objects.requireNonNull(min, "min");
        this.max = Objects.requireNonNull(max, "max");
        this.logScale = logScale;
        this.toMap = Objects.requireNonNull(DoubleRangeParameter.super.toMap(), "toMap");
    }

    private ImmutableDoubleRangeParameter(ImmutableDoubleRangeParameter original, Double min, Double max, boolean logScale) {
        this.min = min;
        this.max = max;
        this.logScale = logScale;
        this.toMap = Objects.requireNonNull(DoubleRangeParameter.super.toMap(), "toMap");
    }

    @Override
    public Double min() {
        return this.min;
    }

    @Override
    public Double max() {
        return this.max;
    }

    @Override
    public boolean logScale() {
        return this.logScale;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableDoubleRangeParameter withMin(Double value) {
        Double newValue = Objects.requireNonNull(value, "min");
        if (this.min.equals(newValue)) {
            return this;
        }
        return new ImmutableDoubleRangeParameter(this, newValue, this.max, this.logScale);
    }

    public final ImmutableDoubleRangeParameter withMax(Double value) {
        Double newValue = Objects.requireNonNull(value, "max");
        if (this.max.equals(newValue)) {
            return this;
        }
        return new ImmutableDoubleRangeParameter(this, this.min, newValue, this.logScale);
    }

    public final ImmutableDoubleRangeParameter withLogScale(boolean value) {
        if (this.logScale == value) {
            return this;
        }
        return new ImmutableDoubleRangeParameter(this, this.min, this.max, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDoubleRangeParameter && this.equalTo(0, (ImmutableDoubleRangeParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableDoubleRangeParameter another) {
        return this.min.equals(another.min) && this.max.equals(another.max) && this.logScale == another.logScale && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min.hashCode();
        h += (h << 5) + this.max.hashCode();
        h += (h << 5) + Boolean.hashCode(this.logScale);
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "DoubleRangeParameter{min=" + this.min + ", max=" + this.max + ", logScale=" + this.logScale + ", toMap=" + this.toMap + "}";
    }

    public static DoubleRangeParameter of(Double min, Double max, boolean logScale) {
        return new ImmutableDoubleRangeParameter(min, max, logScale);
    }

    public static DoubleRangeParameter copyOf(DoubleRangeParameter instance) {
        if (instance instanceof ImmutableDoubleRangeParameter) {
            return (ImmutableDoubleRangeParameter)instance;
        }
        return ImmutableDoubleRangeParameter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DoubleRangeParameter", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private static final long INIT_BIT_LOG_SCALE = 4L;
        private long initBits = 7L;
        private Double min;
        private Double max;
        private boolean logScale;

        private Builder() {
        }

        public final Builder from(DoubleRangeParameter instance) {
            Objects.requireNonNull(instance, "instance");
            this.min((Double)instance.min());
            this.max((Double)instance.max());
            this.logScale(instance.logScale());
            return this;
        }

        public final Builder min(Double min) {
            this.min = Objects.requireNonNull(min, "min");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder max(Double max) {
            this.max = Objects.requireNonNull(max, "max");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder logScale(boolean logScale) {
            this.logScale = logScale;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.min = null;
            this.max = null;
            this.logScale = false;
            return this;
        }

        public DoubleRangeParameter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDoubleRangeParameter(null, this.min, this.max, this.logScale);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("logScale");
            }
            return "Cannot build DoubleRangeParameter, some of required attributes are not set " + attributes;
        }
    }
}

